/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.page.PageProperty;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class PageCompiler<S extends N2oPage, C extends Page>
implements BaseSourceCompiler<C, S, PageContext> {
    protected String initPageRoute(N2oPage source, PageContext context, CompileProcessor p) {
        return RouteUtil.normalize((String)p.cast((Object)context.getRoute((N2oCompileProcessor)p), (Object)source.getRoute(), new Object[]{RouteUtil.normalize(source.getId())}));
    }

    protected void registerRoutes(PageRoutes routes, PageContext context, CompileProcessor p) {
        for (PageRoutes.Route route : routes.getList()) {
            if (route.getIsOtherPage().booleanValue()) continue;
            p.addRoute(route.getPath(), (CompileContext)context);
        }
    }

    protected BreadcrumbList initBreadcrumb(String pageName, PageContext context, CompileProcessor p) {
        if (context instanceof ModalPageContext) {
            return null;
        }
        BreadcrumbList breadcrumbs = new BreadcrumbList();
        if (context.getBreadcrumbs() != null && !context.getBreadcrumbs().isEmpty()) {
            for (Breadcrumb breadcrumb : context.getBreadcrumbs()) {
                breadcrumbs.add((Object)new Breadcrumb(breadcrumb));
            }
            Breadcrumb prev = (Breadcrumb)breadcrumbs.get(breadcrumbs.size() - 1);
            prev.setPath((String)p.cast((Object)prev.getPath(), (Object)context.getParentRoute(), new Object[]{"/"}));
        }
        Breadcrumb current = new Breadcrumb();
        current.setLabel(pageName);
        if (context.getParentModelLink() != null) {
            current.setModelLink(context.getParentModelLink());
        }
        breadcrumbs.add((Object)current);
        return breadcrumbs;
    }

    protected PageProperty initPageName(String pageName, boolean showTitle, PageContext context, CompileProcessor p) {
        PageProperty pageProperty = new PageProperty();
        pageProperty.setHtmlTitle(pageName);
        if (context instanceof ModalPageContext) {
            pageProperty.setHeaderTitle(pageName);
        } else if (showTitle) {
            pageProperty.setTitle(pageName);
        }
        if (context.getParentModelLink() != null) {
            pageProperty.setModelLink(context.getParentModelLink());
        }
        return pageProperty;
    }

    protected abstract String getPropertyPageSrc();
}

