/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSearchablePage;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.SearchablePage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.PageWidgetsScope;
import net.n2oapp.framework.config.metadata.compile.widget.SearchBarScope;
import org.springframework.stereotype.Component;

@Component
public class SearchablePageCompiler
extends BasePageCompiler<N2oSearchablePage, SearchablePage> {
    public SearchablePage compile(N2oSearchablePage source, PageContext context, CompileProcessor p) {
        SearchablePage page = new SearchablePage();
        page.setSearchModelPrefix(ReduxModel.FILTER.getId());
        page.setSearchWidgetId(source.getSearchBar().getSearchWidgetId());
        page.setSearchModelKey(source.getSearchBar().getSearchFilterId());
        page.setSearchBar(this.compileSearchBar(source, p));
        SearchBarScope searchBarScope = new SearchBarScope(page.getSearchWidgetId(), page.getSearchModelKey());
        this.compilePage(source, page, context, p, source.getItems(), searchBarScope);
        if (page.getSearchWidgetId() == null) {
            page.setSearchWidgetId(searchBarScope.getWidgetId());
        }
        this.compileSearchBarRoute(page, source.getSearchBar().getSearchParam());
        return page;
    }

    @Override
    protected void initRegions(N2oSearchablePage source, SearchablePage page, CompileProcessor p, PageContext context, PageScope pageScope, PageRoutes pageRoutes, PageWidgetsScope pageWidgetsScope) {
        HashMap<String, List<Region>> regions = new HashMap<String, List<Region>>();
        this.initRegions(source.getItems(), regions, "single", context, p, pageScope, pageRoutes, pageWidgetsScope, new IndexScope());
        page.setRegions(regions);
    }

    protected SearchablePage.SearchBar compileSearchBar(N2oSearchablePage source, CompileProcessor p) {
        SearchablePage.SearchBar searchBar = new SearchablePage.SearchBar();
        searchBar.setClassName(source.getSearchBar().getClassName());
        searchBar.setTrigger(SearchablePage.SearchBar.TriggerType.valueOf((String)((String)p.resolve(Placeholders.property((String)"n2o.api.page.searchable.trigger"), String.class))));
        searchBar.setPlaceholder(source.getSearchBar().getPlaceholder());
        if (SearchablePage.SearchBar.TriggerType.BUTTON.equals((Object)searchBar.getTrigger())) {
            searchBar.setButton(new SearchablePage.SearchBar.Button());
        } else if (SearchablePage.SearchBar.TriggerType.CHANGE.equals((Object)searchBar.getTrigger())) {
            searchBar.setThrottleDelay((Integer)p.resolve(Placeholders.property((String)"n2o.api.page.searchable.throttle-delay"), Integer.class));
        }
        return searchBar;
    }

    private void compileSearchBarRoute(SearchablePage page, String param) {
        ReduxModel model = ReduxModel.valueOf((String)page.getSearchModelPrefix().toUpperCase());
        if (param == null) {
            param = page.getSearchWidgetId() + "_" + page.getSearchModelKey();
        }
        ModelLink modelLink = new ModelLink(model, page.getSearchWidgetId());
        modelLink.setFieldValue(page.getSearchModelKey());
        page.getRoutes().addQueryMapping((String)param, Redux.dispatchUpdateModel(page.getSearchWidgetId(), model, page.getSearchModelKey(), Placeholders.colon((String)param)), (BindLink)modelLink);
    }

    @Override
    protected String getPropertyPageSrc() {
        return "n2o.api.page.searchable.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSearchablePage.class;
    }
}

