/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.region;

import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.region.N2oPanelRegion;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.region.PanelRegion;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.region.BaseRegionCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.PageWidgetsScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class PanelRegionCompiler
extends BaseRegionCompiler<PanelRegion, N2oPanelRegion> {
    @Override
    protected String getPropertyRegionSrc() {
        return "n2o.api.region.panel.src";
    }

    public Class<N2oPanelRegion> getSourceClass() {
        return N2oPanelRegion.class;
    }

    public PanelRegion compile(N2oPanelRegion source, PageContext context, CompileProcessor p) {
        PanelRegion region = new PanelRegion();
        this.build(region, source, p);
        region.setClassName(source.getCssClass());
        region.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        IndexScope indexScope = (IndexScope)p.getScope(IndexScope.class);
        PageWidgetsScope pageWidgetsScope = (PageWidgetsScope)p.getScope(PageWidgetsScope.class);
        region.setContent(this.initContent(source.getContent(), indexScope, pageWidgetsScope, context, p));
        region.setColor(source.getColor());
        region.setIcon(source.getIcon());
        region.setHeader((Boolean)p.cast((Object)source.getHeader(), (Object)true, new Object[0]));
        region.setFooterTitle(source.getFooterTitle());
        region.setOpen((Boolean)p.cast((Object)source.getOpen(), (Object)true, new Object[0]));
        region.setCollapsible((Boolean)p.cast((Object)source.getCollapsible(), (Object)true, new Object[0]));
        region.setFullScreen(Boolean.valueOf(false));
        this.compilePanelRoute(source, region.getId(), p);
        region.setHeaderTitle(source.getTitle());
        return region;
    }

    private void compilePanelRoute(N2oPanelRegion source, String regionId, CompileProcessor p) {
        String activeParam = (String)p.cast((Object)source.getActiveParam(), (Object)regionId, new Object[0]);
        Boolean routable = (Boolean)p.cast((Object)source.getRoutable(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.region.panel.routable"), Boolean.class)), new Object[0]);
        PageRoutes routes = (PageRoutes)p.getScope(PageRoutes.class);
        if (routes == null || !Boolean.TRUE.equals(routable)) {
            return;
        }
        routes.addQueryMapping(activeParam, Redux.dispatchSetActiveRegionEntity(regionId, activeParam), Redux.createActiveRegionEntityLink(regionId));
    }

    @Override
    protected String createId(String regionPlace, CompileProcessor p) {
        return this.createId(regionPlace, "panel", p);
    }
}

