/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget.table;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.N2oSimpleColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.table.ColumnHeader;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.CellsScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.metadata.compile.widget.table.AbstractHeaderCompiler;
import net.n2oapp.framework.config.util.CompileUtil;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class SimpleColumnHeaderCompiler<T extends N2oSimpleColumn>
extends AbstractHeaderCompiler<T> {
    public Class<? extends Source> getSourceClass() {
        return N2oSimpleColumn.class;
    }

    public ColumnHeader compile(T source, CompileContext<?, ?> context, CompileProcessor p) {
        CompiledQuery query;
        ColumnHeader header = new ColumnHeader();
        source.setId((String)p.cast((Object)source.getId(), (Object)source.getTextFieldId(), new Object[0]));
        source.setSortingFieldId((String)p.cast((Object)source.getSortingFieldId(), (Object)source.getTextFieldId(), new Object[0]));
        N2oCell cell = source.getCell();
        if (cell == null) {
            cell = new N2oTextCell();
        }
        cell = (N2oCell)p.compile((Object)cell, context, new Object[]{new ComponentScope(source)});
        CellsScope cellsScope = (CellsScope)p.getScope(CellsScope.class);
        if (cellsScope != null && cellsScope.getCells() != null) {
            cellsScope.getCells().add(cell);
        }
        header.setId(source.getId());
        header.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.widget.column.src"), String.class)), new Object[0]));
        header.setCssClass(source.getCssClass());
        header.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        header.setIcon(source.getLabelIcon());
        header.setWidth(source.getWidth());
        header.setResizable(source.getResizable());
        header.setFixed(source.getFixed());
        String tableId = null;
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            tableId = widgetScope.getWidgetId();
        }
        if (StringUtils.isLink((Object)source.getVisible())) {
            AbstractColumn.ColumnVisibility[] condition = new Condition();
            condition.setExpression(StringUtils.unwrapLink((String)source.getVisible()));
            String widgetId = CompileUtil.generateWidgetId(((PageScope)p.getScope(PageScope.class)).getPageId(), tableId);
            condition.setModelLink(new ModelLink(ReduxModel.FILTER, widgetId).getBindLink());
            if (!header.getConditions().containsKey(ValidationType.visible)) {
                header.getConditions().put(ValidationType.visible, new ArrayList());
            }
            ((List)header.getConditions().get(ValidationType.visible)).add(condition);
        } else {
            header.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
        }
        if (source.getColumnVisibilities() != null) {
            for (AbstractColumn.ColumnVisibility visibility : source.getColumnVisibilities()) {
                String refWidgetId = CompileUtil.generateWidgetId(((PageScope)p.getScope(PageScope.class)).getPageId(), (String)p.cast((Object)visibility.getRefWidgetId(), (Object)tableId, new Object[0]));
                ReduxModel refModel = (ReduxModel)p.cast((Object)visibility.getRefModel(), (Object)ReduxModel.FILTER, new Object[0]);
                Condition condition = new Condition();
                condition.setExpression(ScriptProcessor.resolveFunction((String)visibility.getValue()));
                condition.setModelLink(new ModelLink(refModel, refWidgetId).getBindLink());
                if (!header.getConditions().containsKey(ValidationType.visible)) {
                    header.getConditions().put(ValidationType.visible, new ArrayList());
                }
                ((List)header.getConditions().get(ValidationType.visible)).add(condition);
            }
        }
        if ((query = (CompiledQuery)p.getScope(CompiledQuery.class)) != null && query.getFieldsMap().containsKey(source.getTextFieldId())) {
            header.setLabel((String)p.cast((Object)source.getLabelName(), (Object)((N2oQuery.Field)query.getFieldsMap().get(source.getTextFieldId())).getName(), new Object[0]));
        } else {
            header.setLabel(source.getLabelName());
        }
        if (query != null && query.getFieldsMap().containsKey(header.getId())) {
            header.setSortable(Boolean.valueOf(((N2oQuery.Field)query.getFieldsMap().get(header.getId())).getNoSorting() == false));
        }
        return header;
    }
}

