/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import org.springframework.stereotype.Component;

@Component
public class QueryValidator
implements SourceValidator<N2oQuery>,
SourceClassAware {
    public void validate(N2oQuery n2oQuery, ValidateProcessor p) {
        if (n2oQuery.getObjectId() != null) {
            this.checkForExistsObject(n2oQuery.getId(), n2oQuery.getObjectId(), p);
        }
        if (n2oQuery.getFields() != null) {
            this.checkForUniqueFields(n2oQuery.getFields(), n2oQuery.getId(), p);
            this.checkForUniqueFilterFields(n2oQuery.getFields(), n2oQuery.getId());
            this.checkForExistsFiltersInSelections(n2oQuery);
        }
    }

    private void checkForExistsObject(String queryId, String objectId, ValidateProcessor p) {
        p.checkForExists(objectId, N2oObject.class, String.format("\u0412\u044b\u0431\u043e\u0440\u043a\u0430 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 %s", queryId, objectId));
    }

    private void checkForUniqueFields(N2oQuery.Field[] fields, String queryId, ValidateProcessor p) {
        p.checkIdsUnique((IdAware[])fields, "\u041f\u043e\u043b\u0435 {0} \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 " + queryId);
    }

    private void checkForUniqueFilterFields(N2oQuery.Field[] fields, String queryId) {
        HashSet<String> filterFields = new HashSet<String>();
        for (N2oQuery.Field field : fields) {
            if (field.isSearchUnavailable()) continue;
            for (N2oQuery.Filter filter : field.getFilterList()) {
                if (filter.getFilterField() == null || filterFields.add(filter.getFilterField())) continue;
                throw new N2oMetadataValidationException(String.format("\u0424\u0438\u043b\u044c\u0442\u0440 %s \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 %s \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u0435\u0442\u0441\u044f", filter.getFilterField(), queryId));
            }
        }
    }

    private void checkForExistsFiltersInSelections(N2oQuery query) {
        Set<String> filterFields = Arrays.stream(query.getFields()).filter(f -> f.getFilterList() != null).flatMap(f -> Arrays.stream(f.getFilterList())).map(N2oQuery.Filter::getFilterField).collect(Collectors.toSet());
        this.checkFiltersExistInSelectionType(query.getLists(), filterFields, "list");
        this.checkFiltersExistInSelectionType(query.getUniques(), filterFields, "unique");
        this.checkFiltersExistInSelectionType(query.getCounts(), filterFields, "count");
    }

    private void checkFiltersExistInSelectionType(N2oQuery.Selection[] selections, Set<String> filterFields, String selectionType) {
        if (selections != null) {
            for (N2oQuery.Selection s : selections) {
                if (s.getFilters() == null) continue;
                for (String filter : s.getFilters().split("\\s*,\\s*")) {
                    if (filterFields.contains(filter)) continue;
                    throw new N2oMetadataValidationException(String.format("<%s> \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0444\u0438\u043b\u044c\u0442\u0440 %s", selectionType, filter));
                }
            }
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }
}

