/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.reader.control;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.control.interval.N2oSimpleIntervalField;
import net.n2oapp.framework.api.metadata.control.list.Inlineable;
import net.n2oapp.framework.api.metadata.control.list.N2oSelectTree;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.api.metadata.reader.NamespaceReader;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.reader.MetadataReaderException;
import net.n2oapp.framework.config.reader.tools.ActionButtonsReaderV1;
import net.n2oapp.framework.config.reader.tools.PreFilterReaderV1Util;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public abstract class N2oStandardControlReaderV1<E extends NamespaceUriAware>
extends AbstractFactoredReader<E>
implements NamespaceReader<E> {
    private ObjectMapper mapper = new ObjectMapper();
    public static final Namespace DEFAULT_EVENT_NAMESPACE_URI = Namespace.getNamespace((String)"http://n2oapp.net/framework/config/schema/n2o-event-1.0");

    public String getNamespaceUri() {
        return "http://n2oapp.net/framework/config/schema/n2o-control-1.0";
    }

    protected void getControlFieldDefinition(Element field, N2oField n2oField) {
        try {
            this.getControlDefinition(field, n2oField);
            String domain = ReaderJdomUtil.getAttributeString(field, "domain");
            n2oField.setDomain(domain);
            if (n2oField instanceof N2oStandardField) {
                ((N2oStandardField)n2oField).setValidations(this.readValidationReferences(field));
                ((N2oStandardField)n2oField).setDefaultValue(ReaderJdomUtil.getAttributeString(field, "default-value"));
            }
            n2oField.setRequired(ReaderJdomUtil.getAttributeString(field, "required"));
            if (ReaderJdomUtil.getAttributeString(field, "depends-on") != null) {
                n2oField.setDependsOn(new String[]{ReaderJdomUtil.getAttributeString(field, "depends-on")});
            }
            n2oField.setNamespaceUri(field.getNamespaceURI());
            this.readDefaultModel(n2oField, field.getChild("default-model", field.getNamespace()));
            n2oField.setLabelStyle(ReaderJdomUtil.getAttributeString(field, "label-style"));
            n2oField.setStyle(ReaderJdomUtil.getAttributeString(field, "control-style"));
            n2oField.setCssClass(ReaderJdomUtil.getAttributeString(field, "css-class"));
            n2oField.setSrc(ReaderJdomUtil.getAttributeString(field, "src"));
            Element dependencies = field.getChild("dependencies", field.getNamespace());
            n2oField.setDependencies(this.readDependencies(dependencies, field));
            this.readSetValues(n2oField, field.getChildren("set-value", field.getNamespace()));
            this.readSetValueExp(n2oField, field.getChildren("set-value-expression", field.getNamespace()));
            ActionButtonsReaderV1 actionButtonsReaderV1 = new ActionButtonsReaderV1();
            actionButtonsReaderV1.setReaderFactory(this.readerFactory);
            List buttons = ReaderJdomUtil.getChildrenAsList(field, "actions", "button", actionButtonsReaderV1);
            if (n2oField instanceof N2oStandardField) {
                ((N2oStandardField)n2oField).setActionButtons(buttons);
                ((N2oStandardField)n2oField).setCopied(ReaderJdomUtil.getAttributeBoolean(field, "copied"));
            }
            if (n2oField instanceof N2oListField) {
                if ("on".equalsIgnoreCase(ReaderJdomUtil.getAttributeString(field, "cache"))) {
                    ((N2oListField)n2oField).setCache(Boolean.valueOf(true));
                } else if ("off".equalsIgnoreCase(ReaderJdomUtil.getAttributeString(field, "cache"))) {
                    ((N2oListField)n2oField).setCache(Boolean.valueOf(false));
                }
            }
        }
        catch (Exception e) {
            throw new MetadataReaderException(e);
        }
    }

    private N2oField.Dependency[] readDependencies(Element element, Element fieldElement) {
        N2oField.Dependency[] dependencies;
        String visibilityCondition = ReaderJdomUtil.getAttributeString(fieldElement, "dependency-condition");
        N2oField.VisibilityDependency visibilityDependency = null;
        if (visibilityCondition != null) {
            visibilityDependency = this.toVisibilityCondition(visibilityCondition);
        }
        int i = 0;
        if (visibilityDependency != null) {
            dependencies = element == null || element.getChildren() == null ? new N2oField.Dependency[1] : new N2oField.Dependency[element.getChildren().size() + 1];
            dependencies[i] = visibilityDependency;
            ++i;
        } else {
            if (element == null || element.getChildren() == null) {
                return null;
            }
            dependencies = new N2oField.Dependency[element.getChildren().size()];
        }
        if (element == null || element.getChildren() == null) {
            return dependencies;
        }
        for (Element dependency : element.getChildren()) {
            if (dependency.getName().equals("enabling-condition")) {
                N2oField.EnablingDependency enablingDependency = new N2oField.EnablingDependency();
                enablingDependency.setOn(dependency.getAttributeValue("on").split(","));
                enablingDependency.setValue(dependency.getValue());
                dependencies[i] = enablingDependency;
                ++i;
                continue;
            }
            if (!dependency.getName().equals("required-condition")) continue;
            N2oField.RequiringDependency requiringDependency = new N2oField.RequiringDependency();
            requiringDependency.setOn(dependency.getAttributeValue("on").split(","));
            requiringDependency.setValue(dependency.getValue());
            dependencies[i] = requiringDependency;
            ++i;
        }
        return dependencies;
    }

    private N2oField.VisibilityDependency toVisibilityCondition(String condition) {
        if (condition == null) {
            return null;
        }
        N2oField.VisibilityDependency res = new N2oField.VisibilityDependency();
        res.setValue(condition);
        res.setOn(ScriptProcessor.extractVars((String)condition).stream().map(f -> f.contains(".") ? f.substring(0, f.indexOf(".")) : f).collect(Collectors.toList()).toArray(new String[0]));
        return res;
    }

    protected void readSetValueExp(N2oField n2oField, List<Element> list) {
        for (Element element : list) {
            N2oField.SetValueDependency setValue = new N2oField.SetValueDependency();
            String on = ReaderJdomUtil.getAttributeString(element, "on");
            setValue.setOn(on != null ? on.split(",") : null);
            setValue.setValue(element.getText());
            n2oField.addDependency((N2oField.Dependency)setValue);
        }
    }

    protected void readSetValues(N2oField n2oField, List<Element> list) {
        for (Element element : list) {
            String ifClause = ReaderJdomUtil.getAttributeString(element, "if");
            String thenClause = ReaderJdomUtil.getAttributeString(element, "then");
            String elseClause = ReaderJdomUtil.getAttributeString(element, "else");
            Element anElse = element.getChild("else", element.getNamespace());
            Map<String, String> elseClauses = this.toMap(anElse);
            Element anThen = element.getChild("then", element.getNamespace());
            Map<String, String> thenClauses = this.toMap(anThen);
            N2oField.SetValueDependency setValue = new N2oField.SetValueDependency();
            String on = ReaderJdomUtil.getAttributeString(element, "on");
            setValue.setOn(on != null ? on.split(",") : null);
            setValue.setValue("if(" + ifClause + ") " + this.calculateReturnStatement(thenClause, thenClauses, null) + "; else " + this.calculateReturnStatement(elseClause, elseClauses, " throw new Error() "));
            n2oField.addDependency((N2oField.Dependency)setValue);
        }
    }

    private String calculateReturnStatement(String returnClause, Map<String, String> returnClauses, String defaultReturn) {
        if (returnClause != null) {
            return this.doLiteral(returnClause);
        }
        if (returnClauses != null && returnClauses.size() != 0) {
            StringBuilder res = new StringBuilder();
            res.append("res={");
            boolean begin = true;
            for (String key : returnClauses.keySet()) {
                if (!begin) {
                    res.append(" ,");
                }
                res.append(key);
                res.append(" : ");
                res.append(this.doLiteral(returnClauses.get(key)));
                begin = false;
            }
            res.append("}");
            return res.toString();
        }
        return defaultReturn;
    }

    private String doLiteral(String returnClause) {
        if ("true".equals(returnClause) || "false".equals(returnClause)) {
            return returnClause;
        }
        return "'" + returnClause + "'";
    }

    protected Map<String, String> toMap(Element anElse) {
        HashMap<String, String> map = null;
        if (anElse != null) {
            map = new HashMap<String, String>();
            List children = anElse.getChildren("value", anElse.getNamespace());
            for (Element value : children) {
                map.put(ReaderJdomUtil.getAttributeString(value, "field-id"), value.getText());
            }
        }
        return map;
    }

    private void readDefaultModel(N2oField field, Element defaultModel) {
        if (defaultModel == null) {
            return;
        }
        if (field instanceof N2oListField) {
            List elements = defaultModel.getChildren("value", defaultModel.getNamespace());
            HashMap values = new HashMap();
            elements.forEach(el -> {
                String fieldId = ReaderJdomUtil.getAttributeString(el, "field-id");
                values.put(fieldId, el.getText());
            });
            ((N2oListField)field).setDefValue(values);
        } else if (field instanceof N2oSimpleIntervalField) {
            ((N2oSimpleIntervalField)field).setBegin(ReaderJdomUtil.getAttributeString(defaultModel, "begin"));
            ((N2oSimpleIntervalField)field).setEnd(ReaderJdomUtil.getAttributeString(defaultModel, "end"));
        }
    }

    protected N2oField.Validations readValidationReferences(Element field) {
        Element validations = field.getChild("validations", field.getNamespace());
        N2oField.Validations inlineValidations = new N2oField.Validations();
        if (validations != null) {
            List list = validations.getChildren("validation", field.getNamespace());
            if (list != null) {
                String[] whiteList = new String[list.size()];
                int i = 0;
                for (Element el : list) {
                    whiteList[i] = ReaderJdomUtil.getAttributeString(el, "ref-id");
                    ++i;
                }
                inlineValidations.setWhiteList(whiteList);
            }
        } else {
            return null;
        }
        return inlineValidations;
    }

    protected void getControlDefinition(Element fieldSetElement, N2oField n2oControl) {
        String label = ReaderJdomUtil.getAttributeString(fieldSetElement, "label");
        String visible = ReaderJdomUtil.getAttributeString(fieldSetElement, "visible");
        n2oControl.setLabel(label);
        n2oControl.setVisible(visible);
        n2oControl.setDescription(ReaderJdomUtil.getElementString(fieldSetElement, "description"));
        n2oControl.setId(ReaderJdomUtil.getAttributeString(fieldSetElement, "id"));
        if (n2oControl instanceof N2oStandardField) {
            ((N2oStandardField)n2oControl).setPlaceholder(ReaderJdomUtil.getAttributeString(fieldSetElement, "placeholder"));
        }
    }

    protected N2oListField getListFieldDefinition(Element element, N2oListField n2oListField) {
        Element query;
        this.getControlFieldDefinition(element, (N2oField)n2oListField);
        N2oStandardControlReaderV1.readAutoSelect(element, n2oListField);
        this.setInlineProperty(element, n2oListField);
        n2oListField.setSize(ReaderJdomUtil.getAttributeInteger(element, "size"));
        Element options = element.getChild("options", element.getNamespace());
        if (options != null) {
            n2oListField.setOptions((Map[])this.readOptions(options));
            this.readSelectFields(options, n2oListField);
        }
        if ((query = element.getChild("query", element.getNamespace())) != null) {
            this.readSelectFields(query, n2oListField);
            Element preFilters = query.getChild("pre-filters", query.getNamespace());
            n2oListField.setPreFilters(PreFilterReaderV1Util.getControlPreFilterListDefinition(preFilters));
        }
        n2oListField.setPopupScaling(ReaderJdomUtil.getAttributeEnum(element, "popup-scaling", N2oListField.PopupScaling.class));
        return n2oListField;
    }

    private Map<String, String>[] readOptions(Element options) {
        HashMap[] optionsMap = new HashMap[options.getChildren().size()];
        int i = 0;
        for (Element option : options.getChildren()) {
            Map map;
            String json = ((Text)option.getContent().get(0)).getValue();
            try {
                map = (Map)this.mapper.readValue(json, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (IOException e) {
                throw new N2oException("Can not resolve json", (Throwable)e);
            }
            optionsMap[i] = map;
            ++i;
        }
        return optionsMap;
    }

    private void readSelectFields(Element query, N2oListField n2oListField) {
        n2oListField.setQueryId(ReaderJdomUtil.getAttributeString(query, "query-id"));
        n2oListField.setLabelFieldId(ReaderJdomUtil.getAttributeString(query, "label-field-id"));
        n2oListField.setValueFieldId(ReaderJdomUtil.getAttributeString(query, "value-field-id"));
        n2oListField.setSearchFilterId(ReaderJdomUtil.getAttributeString(query, "search-field-id"));
        n2oListField.setImageFieldId(ReaderJdomUtil.getAttributeString(query, "image-field-id"));
        n2oListField.setIconFieldId(ReaderJdomUtil.getAttributeString(query, "icon-field-id"));
        n2oListField.setMasterFieldId(ReaderJdomUtil.getAttributeString(query, "master-field-id"));
        n2oListField.setDetailFieldId(ReaderJdomUtil.getAttributeString(query, "detail-field-id"));
        n2oListField.setFormat(ReaderJdomUtil.getAttributeString(query, "format"));
        if (n2oListField.getGroupFieldId() == null) {
            n2oListField.setGroupFieldId(ReaderJdomUtil.getAttributeString(query, "group-field-id"));
        }
    }

    private static void readAutoSelect(Element element, N2oListField n2oListField) {
        n2oListField.setAutoselectAlone(ReaderJdomUtil.getAttributeBoolean(element, "autoselect-alone", "autoselect"));
        n2oListField.setAutoselectFirst(ReaderJdomUtil.getAttributeBoolean(element, "autoselect-first"));
    }

    private void setInlineProperty(Element element, N2oListField n2oListField) {
        if (n2oListField instanceof Inlineable) {
            ((Inlineable)n2oListField).setInline(ReaderJdomUtil.getAttributeBoolean(element, "inline"));
        }
    }

    protected <T extends N2oListField> T getQueryFieldDefinition(Element element, T n2oListField) {
        this.getListFieldDefinition(element, n2oListField);
        n2oListField.setPlaceholder(ReaderJdomUtil.getAttributeString(element, "placeholder"));
        return n2oListField;
    }

    protected void getTreeDefinition(Element element, Namespace namespace, N2oSelectTree selectTree) {
        selectTree.setAjax(ReaderJdomUtil.getAttributeBoolean(element, "ajax"));
        selectTree.setSearch(ReaderJdomUtil.getAttributeBoolean(element, "search"));
        selectTree.setCheckboxes(ReaderJdomUtil.getAttributeBoolean(element, "checkboxes"));
        selectTree.setEnabledFieldId(ReaderJdomUtil.getAttributeString(element, "enabled-field-id"));
        Element in = element.getChild("inheritance-nodes", namespace);
        if (in != null) {
            selectTree.setQueryId(ReaderJdomUtil.getAttributeString(in, "query-id"));
            selectTree.setIconFieldId(ReaderJdomUtil.getAttributeString(in, "icon-field-id"));
            selectTree.setParentFieldId(ReaderJdomUtil.getAttributeString(in, "parent-field-id"));
            selectTree.setLabelFieldId(ReaderJdomUtil.getAttributeString(in, "label-field-id"));
            selectTree.setMasterFieldId(ReaderJdomUtil.getAttributeString(in, "master-field-id"));
            selectTree.setDetailFieldId(ReaderJdomUtil.getAttributeString(in, "detail-field-id"));
            selectTree.setValueFieldId(ReaderJdomUtil.getAttributeString(in, "value-field-id"));
            selectTree.setSearchFilterId(ReaderJdomUtil.getAttributeString(in, "search-field-id"));
            selectTree.setEnabledFieldId(ReaderJdomUtil.getAttributeString(in, "enabled-field-id"));
            selectTree.setHasChildrenFieldId(ReaderJdomUtil.getAttributeString(in, "has-children-field-id"));
            Element preFilters = in.getChild("pre-filters", namespace);
            selectTree.setPreFilters(PreFilterReaderV1Util.getControlPreFilterListDefinition(preFilters));
        }
    }
}

