/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective.persister;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.io.ProxyNamespaceIO;
import net.n2oapp.framework.api.metadata.persister.NamespacePersister;
import net.n2oapp.framework.api.pack.PersistersBuilder;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.util.FileSystemUtil;
import net.n2oapp.framework.config.util.XmlUtil;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SelectivePersister
implements PersistersBuilder<SelectivePersister> {
    private static final Logger logger;
    private static final BiFunction<String, String, Boolean> CANONICAL_COMPARATOR;
    private static final XMLOutputter XML_OUTPUTTER;
    private PersisterFactoryByMap persisterFactory = new PersisterFactoryByMap();
    private IOProcessor persisterProcessor = new IOProcessorImpl(this.persisterFactory);

    public SelectivePersister addPersister(NamespacePersister persister) {
        this.persisterFactory.register((NamespacePersister<? extends NamespaceUriAware>)persister);
        if (persister instanceof IOProcessorAware) {
            ((IOProcessorAware)persister).setIOProcessor(this.persisterProcessor);
        }
        return this;
    }

    public SelectivePersister addPersister(NamespaceIO io) {
        return this.addPersister((NamespacePersister)new ProxyNamespaceIO(io, this.persisterProcessor));
    }

    public boolean persistAndCompareWithSampleByPath(NamespaceUriAware n2o, String samplerPath) {
        return this.persistAndCompareWithSampleByPath(n2o, samplerPath, false);
    }

    public boolean persistAndCompareWithSampleByPath(NamespaceUriAware n2o, String samplerPath, boolean fullEquality) {
        return this.compareWithSampleByPath(n2o, samplerPath, SelectivePersister.chooseComparator(fullEquality));
    }

    public boolean persistAndCompareWithSample(NamespaceUriAware n2o, String sample) {
        return this.compareWithSample(n2o, sample, CANONICAL_COMPARATOR);
    }

    public boolean persistAndCompareWithSample(NamespaceUriAware n2o, String sample, boolean fullEquality) {
        return this.compareWithSample(n2o, sample, SelectivePersister.chooseComparator(fullEquality));
    }

    private static BiFunction<String, String, Boolean> chooseComparator(boolean fullEquality) {
        BiFunction<String, String, Boolean> comparator = fullEquality ? String::equals : CANONICAL_COMPARATOR;
        return comparator;
    }

    private boolean compareWithSampleByPath(NamespaceUriAware n2o, String samplerPath, BiFunction<String, String, Boolean> comparator) {
        return this.compareWithSample(n2o, FileSystemUtil.getContentFromResource((Resource)new ClassPathResource(samplerPath)), comparator);
    }

    private boolean compareWithSample(NamespaceUriAware n2o, String sample, BiFunction<String, String, Boolean> comparator) {
        return comparator.apply(this.toString(n2o), sample);
    }

    private String toString(NamespaceUriAware n2o) {
        Element element = this.persisterFactory.produce(n2o.getClass(), n2o.getNamespace()).persist((Object)n2o, n2o.getNamespace());
        return XML_OUTPUTTER.outputString(element);
    }

    public SelectivePersister persisters(NamespacePersister<? extends NamespaceUriAware> ... persisters) {
        Stream.of(persisters).forEach(this::addPersister);
        return this;
    }

    public SelectivePersister ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(io -> this.persisterFactory.add((NamespacePersister<NamespaceUriAware>)new ProxyNamespaceIO(io)));
        return this;
    }

    static {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        logger = LoggerFactory.getLogger(SelectivePersister.class);
        CANONICAL_COMPARATOR = (s1, s2) -> {
            try {
                Diff diff = XMLUnit.compareXML((String)s1, (String)s2);
                diff.overrideElementQualifier((ElementQualifier)new ElementNameQualifier());
                boolean similar = diff.similar();
                logger.debug("Comparing two xml...\nSource:\n{}\nPersisted:\n{}\nSimilar? {}\nIdentical? {}", new Object[]{s2, s1, similar, diff.identical()});
                logger.debug(diff.toString());
                return similar;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        XML_OUTPUTTER = new XMLOutputter(XmlUtil.N2O_FORMAT);
    }
}

