/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.compile.pipeline.operation;

import java.util.function.Supplier;
import net.n2oapp.cache.template.CacheTemplate;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.event.MetadataChangeListener;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.PipelineOperationTypeAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperation;
import net.n2oapp.framework.api.metadata.pipeline.PipelineOperationType;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.support.NoOpCacheManager;

public class SourceCacheOperation<S extends SourceMetadata>
extends MetadataChangeListener
implements PipelineOperation<S, S>,
PipelineOperationTypeAware,
MetadataEnvironmentAware {
    private String cacheRegion = "n2o.source";
    private CacheTemplate cacheTemplate;
    private MetadataRegister metadataRegister;

    public SourceCacheOperation() {
        this.cacheTemplate = new CacheTemplate((CacheManager)new NoOpCacheManager());
    }

    public SourceCacheOperation(CacheTemplate cacheTemplate, MetadataRegister metadataRegister) {
        this.cacheTemplate = cacheTemplate;
        this.metadataRegister = metadataRegister;
    }

    public PipelineOperationType getPipelineOperationType() {
        return PipelineOperationType.SOURCE_CACHE;
    }

    public S execute(CompileContext<?, ?> context, DataSet data, Supplier<S> supplier, CompileProcessor compileProcessor, BindProcessor bindProcessor, ValidateProcessor validateProcessor) {
        String sourceId = context.getSourceId(bindProcessor);
        SourceInfo info = this.metadataRegister.get(sourceId, context.getSourceClass());
        String key = this.getKey(sourceId, info.getBaseSourceClass());
        SourceMetadata source = (SourceMetadata)this.cacheTemplate.execute(this.cacheRegion, (Object)key, () -> supplier.get());
        return (S)source;
    }

    public void handleAllMetadataChange() {
        Cache cache = this.cacheTemplate.getCacheManager().getCache(this.cacheRegion);
        if (cache != null) {
            this.cacheTemplate.getCacheManager().getCache(this.cacheRegion).clear();
        }
    }

    public void handleMetadataChange(String id, Class<? extends SourceMetadata> sourceClass) {
        this.handleAllMetadataChange();
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.metadataRegister = environment.getMetadataRegister();
    }

    public void setCacheTemplate(CacheTemplate cacheTemplate) {
        this.cacheTemplate = cacheTemplate;
    }

    protected String getKey(String id, Class<? extends SourceMetadata> sourceClass) {
        return id + "." + sourceClass.getSimpleName();
    }

    protected CacheTemplate getCacheTemplate() {
        return this.cacheTemplate;
    }

    protected MetadataRegister getMetadataRegister() {
        return this.metadataRegister;
    }
}

