/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.io;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.engine.factory.EngineNotFoundException;
import net.n2oapp.framework.api.metadata.io.ElementIOFactory;
import net.n2oapp.framework.api.metadata.io.ProxyTypedElementIO;
import net.n2oapp.framework.api.metadata.io.TypedElementIO;
import net.n2oapp.framework.api.metadata.persister.TypedElementPersister;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import org.jdom2.Element;

public class ElementIOFactoryByMap<T, R extends TypedElementReader<? extends T>, P extends TypedElementPersister<? super T>>
implements ElementIOFactory<T, R, P> {
    private Class<T> baseElementClass;
    private Map<String, R> names = new HashMap<String, R>();
    private Map<Class, P> classes = new HashMap<Class, P>();

    public ElementIOFactoryByMap(Class<T> baseElementClass) {
        this.baseElementClass = baseElementClass;
    }

    public ElementIOFactory<T, R, P> add(TypedElementIO<? extends T> tio) {
        ProxyTypedElementIO proxy = new ProxyTypedElementIO(tio);
        this.names.put(tio.getElementName(), proxy);
        this.classes.put(tio.getElementClass(), proxy);
        return this;
    }

    public Class<T> getBaseElementClass() {
        return this.baseElementClass;
    }

    public P produce(Object model) {
        TypedElementPersister engine = (TypedElementPersister)this.classes.get(model.getClass());
        if (engine == null) {
            throw new EngineNotFoundException(model.getClass());
        }
        return (P)engine;
    }

    public R produce(Element element) {
        TypedElementReader engine = (TypedElementReader)this.names.get(element.getName());
        if (engine == null) {
            throw new EngineNotFoundException((Object)element.getName());
        }
        return (R)engine;
    }
}

