/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.ModelAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import net.n2oapp.framework.config.util.CompileUtil;

public abstract class AbstractActionCompiler<D extends Action, S extends N2oAction>
implements BaseSourceCompiler<D, S, CompileContext<?, ?>> {
    public void compileAction(D compiled, S source, CompileProcessor p) {
        ComponentScope componentScope;
        if (source.getId() == null && (componentScope = (ComponentScope)p.getScope(ComponentScope.class)) != null) {
            IdAware component = componentScope.unwrap(IdAware.class);
            if (component != null) {
                source.setId(component.getId());
            } else {
                WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
                if (widgetScope != null) {
                    source.setId(widgetScope.getClientWidgetId() + "_row");
                }
            }
        }
    }

    protected String initTargetWidget(CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String targetWidgetId = ClientDataProviderUtil.getWidgetIdByComponentScope(p);
        if (targetWidgetId == null) {
            if (widgetScope != null) {
                targetWidgetId = widgetScope.getClientWidgetId();
            } else if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null) {
                targetWidgetId = pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
            } else {
                throw new N2oException("Unknown widgetId for invoke action!");
            }
        }
        return targetWidgetId;
    }

    protected ReduxModel getTargetWidgetModel(CompileProcessor p, ReduxModel defaultModel) {
        ModelAware modelAware;
        ComponentScope componentScope = (ComponentScope)p.getScope(ComponentScope.class);
        if (componentScope != null && (modelAware = componentScope.unwrap(ModelAware.class)) != null && modelAware.getModel() != null) {
            return modelAware.getModel();
        }
        return defaultModel;
    }

    protected Map<String, ModelLink> initParentRoutePathMappings(ParentRouteScope routeScope, String url) {
        StrictMap parentRoutePathMappings = new StrictMap();
        if (routeScope != null && routeScope.getPathMapping() != null) {
            List<String> pathParams = RouteUtil.getParams(url);
            routeScope.getPathMapping().forEach((arg_0, arg_1) -> AbstractActionCompiler.lambda$initParentRoutePathMappings$0(pathParams, (Map)parentRoutePathMappings, arg_0, arg_1));
        }
        return parentRoutePathMappings;
    }

    protected void initMappings(N2oParam[] pathParams, N2oParam[] queryParams, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping, CompileProcessor p) {
        WidgetScope scope = (WidgetScope)p.getScope(WidgetScope.class);
        if (scope != null) {
            String defaultClientWidgetId = this.getDefaultClientWidgetId(scope, p);
            ReduxModel defaultModel = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
            if (pathParams != null) {
                for (N2oParam pathParam : pathParams) {
                    pathMapping.put(pathParam.getName(), this.initParamModelLink(pathParam, defaultClientWidgetId, defaultModel, p));
                }
            }
            if (queryParams != null) {
                for (N2oParam queryParam : queryParams) {
                    queryMapping.put(queryParam.getName(), this.initParamModelLink(queryParam, defaultClientWidgetId, defaultModel, p));
                }
            }
        }
    }

    private ModelLink initParamModelLink(N2oParam param, String defaultClientWidgetId, ReduxModel defaultModel, CompileProcessor p) {
        String widgetId = param.getRefWidgetId() != null ? CompileUtil.generateWidgetId(((PageScope)p.getScope(PageScope.class)).getPageId(), param.getRefWidgetId()) : defaultClientWidgetId;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String datasource = pageScope == null ? widgetId : pageScope.getWidgetIdDatasourceMap().get(widgetId);
        ModelLink link = new ModelLink((ReduxModel)p.cast((Object)param.getRefModel(), (Object)defaultModel, new Object[0]), datasource);
        link.setValue((Object)p.resolveJS(param.getValue()));
        return link;
    }

    private String getDefaultClientWidgetId(WidgetScope widgetScope, CompileProcessor p) {
        String widgetIdByComponentScope = ClientDataProviderUtil.getWidgetIdByComponentScope(p);
        return widgetIdByComponentScope != null ? widgetIdByComponentScope : widgetScope.getClientWidgetId();
    }

    private static /* synthetic */ void lambda$initParentRoutePathMappings$0(List pathParams, Map parentRoutePathMappings, String k, ModelLink v) {
        if (pathParams.contains(k)) {
            parentRoutePathMappings.put(k, v);
        }
    }
}

