/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.Map;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.modal.AbstractModal;
import net.n2oapp.framework.api.metadata.meta.action.modal.ModalPayload;
import net.n2oapp.framework.api.metadata.meta.saga.CloseSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractOpenPageCompiler;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.register.route.RouteUtil;

public abstract class AbstractModalCompiler<D extends AbstractModal, S extends N2oAbstractPageAction>
extends AbstractOpenPageCompiler<D, S> {
    public void compileModal(S source, D compiled, CompileContext<?, ?> context, CompileProcessor p) {
        compiled.setObjectId(source.getObjectId());
        compiled.setOperationId(source.getOperationId());
        compiled.setPageId(source.getPageId());
        this.compileAction(compiled, source, p);
        PageContext pageContext = this.initPageContext(compiled, source, context, p);
        this.initOnCloseMeta(compiled, pageContext, p);
        this.compilePayload(source, compiled, pageContext, p);
    }

    protected abstract void compilePayload(S var1, D var2, PageContext var3, CompileProcessor var4);

    @Override
    protected void initPageRoute(D compiled, String route, Map<String, ModelLink> pathMapping, Map<String, ModelLink> queryMapping) {
        ModalPayload payload = (ModalPayload)compiled.getPayload();
        String modalPageId = RouteUtil.convertPathToId(route);
        payload.setName(modalPageId);
        payload.setPageId(modalPageId);
        payload.setPageUrl(route);
        payload.setPathMapping(pathMapping);
        payload.setQueryMapping(queryMapping);
    }

    private void initOnCloseMeta(D compiled, PageContext context, CompileProcessor p) {
        if (!Boolean.TRUE.equals(context.getRefreshOnClose())) {
            return;
        }
        if (compiled.getMeta() == null) {
            compiled.setMeta(new MetaSaga());
        }
        compiled.getMeta().setOnClose(new CloseSaga());
        RefreshSaga refreshSaga = new RefreshSaga();
        refreshSaga.setType(RefreshSaga.Type.widget);
        refreshSaga.getOptions().setWidgetId((String)p.cast((Object)context.getRefreshClientWidgetId(), (Object)context.getParentClientWidgetId(), new Object[0]));
        compiled.getMeta().getOnClose().setRefresh(refreshSaga);
    }
}

