/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.menu;

import java.util.ArrayList;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.event.action.N2oAbstractPageAction;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.header.HeaderItem;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SimpleMenuCompiler
implements BaseSourceCompiler<SimpleMenu, N2oSimpleMenu, ApplicationContext>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oSimpleMenu.class;
    }

    public SimpleMenu compile(N2oSimpleMenu source, ApplicationContext context, CompileProcessor p) {
        IndexScope idx;
        SimpleMenu simpleMenu = new SimpleMenu();
        ArrayList<HeaderItem> items = new ArrayList<HeaderItem>();
        IndexScope indexScope = idx = p.getScope(IndexScope.class) != null ? (IndexScope)p.getScope(IndexScope.class) : new IndexScope(1);
        if (source.getMenuItems() != null) {
            for (N2oSimpleMenu.AbstractMenuItem mi : source.getMenuItems()) {
                items.add(this.createMenuItem(mi, p, context, idx));
            }
        }
        simpleMenu.setItems(items);
        return simpleMenu;
    }

    private HeaderItem createMenuItem(N2oSimpleMenu.AbstractMenuItem source, CompileProcessor p, ApplicationContext context, IndexScope idx) {
        HeaderItem compiled = new HeaderItem();
        source.setId((String)p.cast((Object)source.getId(), (Object)("mi" + idx.get()), new Object[0]));
        compiled.setId(source.getId());
        compiled.setTitle(source.getName());
        compiled.setIcon(source.getIcon());
        compiled.setImageSrc(source.getImage());
        compiled.setImageShape(source.getImageShape());
        if (source instanceof N2oSimpleMenu.MenuItem) {
            this.menuItem((N2oSimpleMenu.MenuItem)source, compiled, p, context);
        } else if (source instanceof N2oSimpleMenu.DropdownMenuItem) {
            this.dropdownMenu((N2oSimpleMenu.DropdownMenuItem)source, compiled, p, context, idx);
        }
        compiled.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        return compiled;
    }

    private void menuItem(N2oSimpleMenu.MenuItem source, HeaderItem compiled, CompileProcessor p, ApplicationContext context) {
        compiled.setBadge(p.resolve(source.getBadge()));
        compiled.setBadgeColor(source.getBadgeColor());
        compiled.setType("link");
        compiled.setPageId(this.initPageId(source.getAction()));
        if (source.getName() == null) {
            compiled.setTitle(this.initDefaultName(source.getAction(), p));
        }
        if (source.getAction() != null) {
            Action action = (Action)p.compile((Object)source.getAction(), (CompileContext)context, new Object[]{new ComponentScope(source)});
            if (action instanceof LinkAction) {
                LinkAction linkAction = (LinkAction)action;
                compiled.setHref(linkAction.getUrl());
                if (linkAction.getTarget().equals((Object)Target.application)) {
                    compiled.setLinkType(HeaderItem.LinkType.inner);
                } else {
                    compiled.setLinkType(HeaderItem.LinkType.outer);
                }
            } else {
                throw new N2oException("Action " + action.getClass() + " not supported in menu yet");
            }
        }
    }

    private String initPageId(N2oAction action) {
        return action instanceof N2oAbstractPageAction ? ((N2oAbstractPageAction)action).getPageId() : null;
    }

    private String initDefaultName(N2oAction action, CompileProcessor p) {
        String pageId = this.initPageId(action);
        if (pageId == null) {
            return null;
        }
        N2oPage page = (N2oPage)p.getSource(pageId, N2oPage.class);
        return page.getName();
    }

    private void dropdownMenu(N2oSimpleMenu.DropdownMenuItem source, HeaderItem item, CompileProcessor p, ApplicationContext context, IndexScope idx) {
        item.setType("dropdown");
        ArrayList<HeaderItem> subItems = new ArrayList<HeaderItem>();
        for (N2oSimpleMenu.MenuItem subItem : source.getMenuItems()) {
            subItems.add(this.createMenuItem((N2oSimpleMenu.AbstractMenuItem)subItem, p, context, idx));
        }
        item.setSubItems(subItems);
    }
}

