/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.FormMode;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.api.metadata.meta.widget.form.Form;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.widget.BaseWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;
import org.springframework.stereotype.Component;

@Component
public class FormCompiler
extends BaseWidgetCompiler<Form, N2oForm> {
    public Class<N2oForm> getSourceClass() {
        return N2oForm.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.form.src";
    }

    public Form compile(N2oForm source, CompileContext<?, ?> context, CompileProcessor p) {
        Form form = new Form();
        form.getComponent().setPrompt((Boolean)p.cast((Object)source.getPrompt(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.form.unsaved_data_prompt"), Boolean.class)), new Object[0]));
        CompiledQuery query = this.getQuery(source, p);
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(form, source, context, p, object);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope == null) {
            widgetScope = new WidgetScope();
        }
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        widgetScope.setClientWidgetId(form.getId());
        MetaActions widgetActions = this.initMetaActions(source);
        ParentRouteScope widgetRoute = this.initWidgetRouteScope(form, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(form.getId(), widgetRoute);
        }
        Models models = (Models)p.getScope(Models.class);
        UploadScope uploadScope = new UploadScope();
        uploadScope.setUpload(form.getUpload());
        SubModelsScope subModelsScope = new SubModelsScope();
        CopiedFieldScope copiedFieldScope = new CopiedFieldScope();
        WidgetParamScope paramScope = form.getUpload().equals((Object)UploadType.defaults) ? new WidgetParamScope() : null;
        form.getComponent().setFieldsets(this.initFieldSets(source.getItems(), context, p, widgetScope, query, object, widgetActions, new ModelsScope(ReduxModel.RESOLVE, form.getId(), models), null, subModelsScope, uploadScope, new MomentScope(N2oValidation.ServerMoment.beforeOperation), copiedFieldScope, widgetRoute, paramScope, new ComponentScope(source)));
        ValidationList validationList = p.getScope(ValidationList.class) == null ? new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>()) : (ValidationList)p.getScope(ValidationList.class);
        ValidationScope validationScope = new ValidationScope(form.getId(), ReduxModel.RESOLVE, validationList);
        this.compileValidation(form, source, validationScope);
        this.compileDataProviderAndRoutes(form, source, context, p, validationList, widgetRoute, subModelsScope, copiedFieldScope, object);
        this.addParamRoutes(paramScope, context, p);
        this.compileToolbarAndAction(form, source, context, p, widgetScope, widgetRoute, widgetActions, object, validationList);
        form.getComponent().setModelPrefix(FormMode.TWO_MODELS.equals((Object)source.getMode()) ? "edit" : "resolve");
        form.setFormDataProvider(this.initDataProvider(source, object, context, p));
        return form;
    }

    private ClientDataProvider initDataProvider(N2oForm source, CompiledObject compiledObject, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromSubmit(source.getSubmit(), source.getId(), compiledObject, p);
        dataProvider.setSubmitForm(Boolean.valueOf(true));
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            dataProvider.setTargetWidgetId(widgetScope.getClientWidgetId());
        }
        dataProvider.getActionContextData().setSuccessAlertWidgetId(source.getId());
        dataProvider.getActionContextData().setFailAlertWidgetId(source.getId());
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }

    private void compileValidation(Form form, N2oForm source, ValidationScope validationScope) {
        if (source.getItems() == null) {
            return;
        }
        HashMap clientValidations = new HashMap();
        form.getComponent().getFieldsets().forEach(fs -> this.collectValidation((FieldSet)fs, clientValidations, validationScope));
        form.getComponent().setValidation(clientValidations);
    }
}

