/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oSearchButtons;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oTable;
import net.n2oapp.framework.api.metadata.global.view.widget.table.RowSelectionEnum;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.AbstractColumn;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.control.SearchButtons;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.metadata.meta.widget.Rows;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.api.metadata.meta.widget.table.AbstractTable;
import net.n2oapp.framework.api.metadata.meta.widget.table.ColumnHeader;
import net.n2oapp.framework.api.metadata.meta.widget.table.Table;
import net.n2oapp.framework.api.metadata.meta.widget.table.TableWidgetComponent;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.ValidationScope;
import net.n2oapp.framework.config.metadata.compile.context.QueryContext;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.CellsScope;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class TableCompiler
extends BaseListWidgetCompiler<Table, N2oTable> {
    public Class<? extends Source> getSourceClass() {
        return N2oTable.class;
    }

    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.table.src";
    }

    public Table compile(N2oTable source, CompileContext<?, ?> context, CompileProcessor p) {
        Table table = new Table();
        table.setFiltersDefaultValuesQueryId(source.getFiltersDefaultValuesQueryId());
        TableWidgetComponent component = table.getComponent();
        CompiledQuery query = this.getQuery(source, p);
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(table, source, context, p, object);
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setClientWidgetId(table.getId());
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        widgetScope.setHasIdInParentRoute(true);
        Models models = (Models)p.getScope(Models.class);
        SubModelsScope subModelsScope = new SubModelsScope();
        UploadScope uploadScope = new UploadScope();
        uploadScope.setUpload(UploadType.defaults);
        FiltersScope filtersScope = new FiltersScope(table.getFilters());
        table.setFilter(this.createFilter(source, context, p, widgetScope, query, object, new ModelsScope(ReduxModel.FILTER, table.getId(), models), filtersScope, subModelsScope, uploadScope, new MomentScope(N2oValidation.ServerMoment.beforeQuery)));
        ValidationList validationList = p.getScope(ValidationList.class) == null ? new ValidationList(new EnumMap<ReduxModel, Map<String, List<Validation>>>(ReduxModel.class)) : (ValidationList)p.getScope(ValidationList.class);
        ValidationScope validationScope = new ValidationScope(table.getId(), ReduxModel.FILTER, validationList);
        this.compileValidation(table, source, validationScope);
        ParentRouteScope widgetRouteScope = this.initWidgetRouteScope(table, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(table.getId(), widgetRouteScope);
        }
        MetaActions widgetActions = this.initMetaActions(source);
        this.compileToolbarAndAction(table, source, context, p, widgetScope, widgetRouteScope, widgetActions, object, null);
        this.compileColumns(source, context, p, component, query, object, widgetScope, widgetRouteScope, widgetActions, uploadScope, subModelsScope, filtersScope);
        this.compileDataProviderAndRoutes(table, source, context, p, validationList, widgetRouteScope, null, null, object);
        component.setSize((Integer)p.cast((Object)source.getSize(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.table.size"), Integer.class)), new Object[0]));
        component.setTableSize(source.getTableSize() != null ? source.getTableSize().name().toLowerCase() : null);
        component.setWidth(source.getWidth());
        component.setHeight(source.getHeight());
        component.setTextWrap((Boolean)p.cast((Object)source.getTextWrap(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.text_wrap"), Boolean.class)), new Object[0]));
        if (source.getRows() != null) {
            component.setRows(new Rows());
            if (source.getRows().getRowClass() != null) {
                component.setRowClass(p.resolveJS(source.getRows().getRowClass()));
            } else if (source.getRows().getColor() != null) {
                HashMap<Object, String> resolvedCases = new HashMap<Object, String>();
                for (String key : source.getRows().getColor().getCases().keySet()) {
                    resolvedCases.put(p.resolve(key), (String)source.getRows().getColor().getCases().get(key));
                }
                source.getRows().getColor().setResolvedCases(resolvedCases);
                component.setRowClass(ScriptProcessor.buildSwitchExpression((N2oSwitch)source.getRows().getColor()));
            }
            component.setRowClick(this.compileRowClick((N2oAbstractListWidget)source, context, p, widgetScope, widgetRouteScope, object, widgetActions));
        }
        table.setPaging(this.compilePaging((Widget)table, (N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.table.size"), Integer.class), p));
        table.setChildren((N2oTable.ChildrenToggle)p.cast((Object)source.getChildren(), (Object)((N2oTable.ChildrenToggle)p.resolve(Placeholders.property((String)"n2o.api.widget.table.children.toggle"), N2oTable.ChildrenToggle.class)), new Object[0]));
        component.setAutoCheckboxOnSelect((Boolean)p.cast((Object)source.getCheckOnSelect(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.widget.table.check_on_select"), Boolean.class)), new Object[0]));
        if (Boolean.TRUE.equals(source.getCheckboxes())) {
            component.setRowSelection(RowSelectionEnum.checkbox);
        }
        return table;
    }

    @Override
    protected QueryContext getQueryContext(Table widget, N2oTable source, CompileContext<?, ?> context, String route, ValidationList validationList, SubModelsScope subModelsScope, CopiedFieldScope copiedFieldScope, CompiledObject object) {
        QueryContext queryContext = super.getQueryContext(widget, source, context, route, validationList, subModelsScope, copiedFieldScope, object);
        queryContext.setSortingMap((Map<String, String>)new StrictMap());
        if (source.getColumns() != null) {
            for (AbstractColumn column : source.getColumns()) {
                String id = column.getId() != null ? column.getId() : column.getTextFieldId();
                String sortingFieldId = column.getSortingFieldId() != null ? column.getSortingFieldId() : column.getTextFieldId();
                queryContext.getSortingMap().put(id, sortingFieldId);
            }
        }
        return queryContext;
    }

    @Override
    protected String getMessagesForm(Widget widget) {
        return widget.getId() + "_filter";
    }

    private void compileValidation(Table table, N2oTable source, ValidationScope validationScope) {
        if (source.getFilters() == null) {
            return;
        }
        HashMap clientValidations = new HashMap();
        table.getFilter().getFilterFieldsets().forEach(fs -> this.collectValidation((FieldSet)fs, clientValidations, validationScope));
        table.getFilter().setValidation(clientValidations);
    }

    private void compileColumns(N2oTable source, CompileContext<?, ?> context, CompileProcessor p, TableWidgetComponent component, CompiledQuery query, CompiledObject object, Object ... scopes) {
        if (source.getColumns() != null) {
            ArrayList<ColumnHeader> headers = new ArrayList<ColumnHeader>();
            HashMap<String, String> sortings = new HashMap<String, String>();
            IndexScope columnIndex = new IndexScope();
            CellsScope cellsScope = new CellsScope(new ArrayList<N2oCell>());
            for (AbstractColumn column : source.getColumns()) {
                headers.add((ColumnHeader)p.compile((Object)column, context, new Object[]{p, new ComponentScope(column), object, columnIndex, cellsScope, query, scopes}));
                if (column.getSortingDirection() == null) continue;
                sortings.put(column.getTextFieldId(), column.getSortingDirection().toString().toUpperCase());
            }
            component.setHeaders(headers);
            component.setCells(cellsScope.getCells());
            component.setSorting(sortings);
            RowSelectionEnum rowSelection = (RowSelectionEnum)p.cast((Object)source.getSelection(), (Object)((RowSelectionEnum)p.resolve(Placeholders.property((String)"n2o.api.widget.table.selection"), RowSelectionEnum.class)), new Object[0]);
            switch (rowSelection) {
                case none: {
                    component.setHasSelect(Boolean.valueOf(false));
                    component.setHasFocus(Boolean.valueOf(false));
                    break;
                }
                case active: {
                    component.setHasSelect(Boolean.valueOf(true));
                    component.setHasFocus(Boolean.valueOf(true));
                    break;
                }
                case radio: 
                case checkbox: {
                    component.setRowSelection(rowSelection);
                }
            }
        }
    }

    private AbstractTable.Filter createFilter(N2oTable source, CompileContext<?, ?> context, CompileProcessor p, WidgetScope widgetScope, CompiledQuery widgetQuery, CompiledObject object, Object ... scopes) {
        List<FieldSet> fieldSets = this.initFieldSets(source.getFilters(), context, p, widgetScope, widgetQuery, object, scopes);
        if (fieldSets.isEmpty()) {
            return null;
        }
        AbstractTable.Filter filter = new AbstractTable.Filter();
        filter.setFilterFieldsets(fieldSets);
        filter.setFilterButtonId("filter");
        filter.setBlackResetList(new ArrayList(Arrays.stream(source.getFilters()).filter(f -> f instanceof N2oSearchButtons && ((N2oSearchButtons)f).getClearIgnore() != null).flatMap(f -> Arrays.stream(((N2oSearchButtons)f).getClearIgnore().split(","))).map(String::trim).collect(Collectors.toSet())));
        filter.setFilterPlace((N2oTable.FilterPosition)p.cast((Object)source.getFilterPosition(), (Object)N2oTable.FilterPosition.top, new Object[0]));
        boolean hasSearchButtons = fieldSets.stream().flatMap(fs -> fs.getRows() != null ? fs.getRows().stream() : Stream.empty()).flatMap(r -> r.getCols() != null ? r.getCols().stream() : Stream.empty()).flatMap(c -> c.getFields() != null ? c.getFields().stream() : Stream.empty()).filter(f -> f instanceof StandardField).map(f -> ((StandardField)f).getControl()).anyMatch(c -> c instanceof SearchButtons);
        filter.setSearchOnChange(source.getSearchOnChange());
        if (hasSearchButtons || filter.getSearchOnChange() != null && filter.getSearchOnChange().booleanValue()) {
            filter.setHideButtons(Boolean.valueOf(true));
        }
        return filter;
    }
}

