/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.object;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.IdAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.object.AbstractParameter;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.dao.object.field.ObjectReferenceField;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import org.springframework.stereotype.Component;

@Component
public class ObjectValidator
implements SourceValidator<N2oObject>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oObject.class;
    }

    public void validate(N2oObject object, ValidateProcessor p) {
        p.checkIdsUnique((IdAware[])object.getObjectFields(), "\u041f\u043e\u043b\u0435 {0} \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 " + object.getId());
        p.checkIdsUnique((IdAware[])object.getOperations(), "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u0435 {0} \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 " + object.getId());
        p.checkIdsUnique((IdAware[])object.getN2oValidations(), "\u0412\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u044f {0} \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 " + object.getId());
        if (object.getObjectFields() != null && object.getObjectFields().length != 0) {
            this.checkForExistsReferenceObject(object.getId(), object.getObjectFields(), p);
        }
        if (object.getOperations() != null) {
            for (N2oObject.Operation operation : object.getOperations()) {
                if (operation.getInFields() != null) {
                    this.checkForExistsReferenceObject(object.getId(), operation.getInFields(), p);
                }
                if (operation.getInvocation() == null) continue;
                p.validate((Source)operation.getInvocation(), new Object[0]);
            }
        }
    }

    private void checkForExistsReferenceObject(String objectId, AbstractParameter[] fields, ValidateProcessor p) {
        for (AbstractParameter field : fields) {
            if (!(field instanceof ObjectReferenceField)) continue;
            ObjectReferenceField refField = (ObjectReferenceField)field;
            if (refField.getReferenceObjectId() != null) {
                p.checkForExists(refField.getReferenceObjectId(), N2oObject.class, String.format("\u041f\u043e\u043b\u0435 '%s' \u0432 \u043e\u0431\u044a\u0435\u043a\u0442\u0435 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 '%s'", refField.getId(), objectId, refField.getReferenceObjectId()));
            }
            if (refField.getFields() == null || refField.getFields().length == 0) continue;
            this.checkForExistsReferenceObject(objectId, refField.getFields(), p);
        }
    }
}

