/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.config.test.JsonMetadataTester;
import org.springframework.core.io.Resource;

public class JsonChecker {
    private Resource jsonResource;
    private CompileContext<?, ?> context;
    private JsonMetadataTester tester;
    private String jsonCutPath;
    private String xmlCutPath;
    private List<String> jsonExcludePaths = new ArrayList<String>();
    private Map<String, Object> jsonChangeValuePath = new HashMap<String, Object>();
    private Map<String, String> jsonChangeNodePath = new HashMap<String, String>();

    public JsonChecker(JsonMetadataTester tester) {
        this.tester = tester;
    }

    public JsonChecker(Resource jsonResource, JsonMetadataTester tester) {
        this(tester);
        this.jsonResource = jsonResource;
    }

    public JsonChecker(CompileContext<?, ?> context, Resource jsonResource, JsonMetadataTester tester) {
        this(jsonResource, tester);
        this.context = context;
    }

    @Deprecated
    public JsonChecker jsonExcludePaths(List<String> jsonExcludePaths) {
        this.jsonExcludePaths = jsonExcludePaths;
        return this;
    }

    public JsonChecker cutJson(String jsonCutPath) {
        this.jsonCutPath = jsonCutPath;
        return this;
    }

    public JsonChecker cutXml(String xmlCutPath) {
        this.xmlCutPath = xmlCutPath;
        return this;
    }

    public JsonChecker exclude(String ... jsonExcludePaths) {
        this.jsonExcludePaths.addAll(Arrays.asList(jsonExcludePaths));
        return this;
    }

    public JsonChecker changeValue(String jsonChangePath, String value) {
        this.jsonChangeValuePath.put(jsonChangePath, value);
        return this;
    }

    public JsonChecker changeNode(String jsonNodePath, String jsonChangeNodePath) {
        this.jsonChangeNodePath.put(jsonNodePath, jsonChangeNodePath);
        return this;
    }

    public void assertEquals(String route, Class<? extends Compiled> compiledClass) {
        try {
            this.tester.check(route, compiledClass, this.jsonResource, this.xmlCutPath, this.jsonCutPath, this.jsonExcludePaths, this.jsonChangeValuePath, this.jsonChangeNodePath, new HashMap<String, String[]>());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assertEquals(String route, Class<? extends Compiled> compiledClass, Map<String, String[]> queryParams) {
        try {
            this.tester.check(route, compiledClass, this.jsonResource, this.xmlCutPath, this.jsonCutPath, this.jsonExcludePaths, this.jsonChangeValuePath, this.jsonChangeNodePath, queryParams);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assertEquals(CompileContext<?, ?> context) {
        try {
            this.tester.check(this.jsonResource, context, new DataSet(), this.xmlCutPath, this.jsonCutPath, this.jsonExcludePaths, this.jsonChangeValuePath, this.jsonChangeNodePath);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assertEquals(CompileContext<?, ?> context, DataSet data) {
        try {
            this.tester.check(this.jsonResource, context, data, this.xmlCutPath, this.jsonCutPath, this.jsonExcludePaths, this.jsonChangeValuePath, this.jsonChangeNodePath);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assertEquals() {
        this.assertEquals(this.context);
    }

    public void assertEquals(DataSet jsonSource, CompileContext<?, ?> context) {
        try {
            this.tester.check(jsonSource, context, new DataSet(), this.xmlCutPath, this.jsonExcludePaths);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void assertEquals(DataSet jsonSource, CompileContext<?, ?> context, DataSet data) {
        try {
            this.tester.check(jsonSource, context, data, this.xmlCutPath, this.jsonExcludePaths);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

