/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import net.n2oapp.framework.api.event.MetadataChangedEvent;
import net.n2oapp.framework.api.event.N2oEvent;
import net.n2oapp.framework.api.event.N2oEventBus;
import net.n2oapp.framework.api.register.MetadataRegister;
import net.n2oapp.framework.api.register.SourceInfo;
import net.n2oapp.framework.api.register.SourceTypeRegister;
import net.n2oapp.framework.config.register.FileInfo;
import net.n2oapp.framework.config.register.RegisterUtil;
import net.n2oapp.framework.config.register.storage.Node;
import net.n2oapp.watchdir.FileChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLChangeListener
implements FileChangeListener {
    private static final Logger log = LoggerFactory.getLogger(XMLChangeListener.class);
    private final Collection<String> watchFolderPaths;
    private final MetadataRegister configRegister;
    private final SourceTypeRegister sourceTypeRegister;
    private final N2oEventBus eventBus;

    public XMLChangeListener(Collection<String> configPath, MetadataRegister configRegister, SourceTypeRegister sourceTypeRegister, N2oEventBus eventBus) {
        this.watchFolderPaths = configPath;
        this.configRegister = configRegister;
        this.sourceTypeRegister = sourceTypeRegister;
        this.eventBus = eventBus;
    }

    public void fileModified(Path file) {
        try {
            if (file.toFile().isDirectory() || !XMLChangeListener.isXMl(file)) {
                return;
            }
            SourceInfo info = this.getSourceInfo(file.toAbsolutePath().toString());
            this.configRegister.update(info);
            this.eventBus.publish((N2oEvent)new MetadataChangedEvent((Object)this, info.getId(), info.getBaseSourceClass()));
            log.debug("Modified handled: " + file);
        }
        catch (Exception e) {
            log.error("Fail modified handled: " + file, (Throwable)e);
        }
    }

    public void fileCreated(Path file) {
        try {
            if (file.toFile().isDirectory() || !XMLChangeListener.isXMl(file)) {
                block5: {
                    try {
                        Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                            @Override
                            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                if (XMLChangeListener.isXMl(file)) {
                                    XMLChangeListener.this.addSourceFromMemory(file);
                                }
                                return super.visitFile(file, attrs);
                            }
                        });
                    }
                    catch (IOException ignored) {
                        if (!file.toFile().isDirectory()) break block5;
                        log.error("Created not handled: error add directory " + file);
                    }
                }
                return;
            }
            this.addSourceFromMemory(file);
        }
        catch (Exception e) {
            log.error("Fail created handled: " + file, (Throwable)e);
        }
    }

    public void fileDeleted(Path file) {
        try {
            if (!file.toFile().isDirectory() && XMLChangeListener.isXMl(file)) {
                this.deleteSourceFromMemory(file.toAbsolutePath().toString());
            } else {
                this.deleteSourceFromMemoryByPath(file.toAbsolutePath().toString());
            }
        }
        catch (Exception e) {
            log.error("Fail deleted handled: " + file, (Throwable)e);
        }
    }

    private void deleteSourceFromMemory(String path) {
        SourceInfo info = this.getSourceInfo(path);
        this.configRegister.remove(info.getId(), info.getBaseSourceClass());
        this.eventBus.publish((N2oEvent)new MetadataChangedEvent((Object)this, info.getId(), info.getBaseSourceClass()));
        log.debug("Deleted handled: " + path);
    }

    private void deleteSourceFromMemoryByPath(String path) {
        if (path.lastIndexOf(47) <= path.lastIndexOf(46)) {
            return;
        }
        Node node = Node.byAbsolutePath(path, this.getConfigPath(path));
        List sourceInfoList = this.configRegister.find(s -> s instanceof FileInfo && ((FileInfo)((Object)s)).getLocalPath().startsWith(node.getLocalPath()));
        for (SourceInfo info : sourceInfoList) {
            this.configRegister.remove(info.getId(), info.getBaseSourceClass());
            this.eventBus.publish((N2oEvent)new MetadataChangedEvent((Object)this, info.getId(), info.getBaseSourceClass()));
        }
        log.debug("Deleted handled: " + path);
    }

    private SourceInfo getSourceInfo(String path) {
        return RegisterUtil.createFolderInfo(Node.byAbsolutePath(path, this.getConfigPath(path)), this.sourceTypeRegister);
    }

    private void addSourceFromMemory(Path path) {
        SourceInfo info = this.getSourceInfo(path.toString());
        this.configRegister.add(info);
        this.eventBus.publish((N2oEvent)new MetadataChangedEvent((Object)this, info.getId(), info.getBaseSourceClass()));
        log.debug("Created handled: " + path);
    }

    private static boolean isXMl(Path file) {
        String fileName = "" + file.getFileName();
        return fileName.toLowerCase().endsWith(".xml");
    }

    private String getConfigPath(String file) {
        for (String path : this.watchFolderPaths) {
            if (!file.startsWith(path)) continue;
            return path;
        }
        return "";
    }
}

