/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oActionField;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oForm;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.control.ActionField;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;

public abstract class ActionFieldCompiler<D extends ActionField, S extends N2oField>
extends FieldCompiler<D, S> {
    protected Action compileAction(N2oActionField source, ActionField field, CompileContext<?, ?> context, CompileProcessor p) {
        ComponentScope scope = null;
        N2oAction action = null;
        if (source.getAction() != null) {
            scope = new ComponentScope(source);
            action = source.getAction();
        } else if (source.getActionId() != null) {
            scope = (ComponentScope)p.getScope(ComponentScope.class);
            action = this.getAction(scope, source.getActionId());
        }
        if (action != null) {
            String objectId = action.getObjectId();
            CompiledObject compiledObject = this.getCompiledObject(p, objectId);
            action.setId((String)p.cast((Object)action.getId(), (Object)field.getId(), new Object[0]));
            Action result = (Action)p.compile((Object)action, context, new Object[]{compiledObject, scope});
            if (result instanceof LinkAction) {
                LinkAction linkAction = (LinkAction)result;
                field.setUrl(linkAction.getUrl());
                field.setTarget(linkAction.getTarget());
                field.setPathMapping(linkAction.getPathMapping());
                field.setQueryMapping(linkAction.getQueryMapping());
            } else {
                field.setAction(result);
            }
            return result;
        }
        return null;
    }

    protected N2oAction getAction(ComponentScope scope, String actionId) {
        N2oForm form;
        if (scope != null && (form = scope.unwrap(N2oForm.class)) != null && form.getActions() != null) {
            for (ActionsBar act : form.getActions()) {
                if (!actionId.equals(act.getId())) continue;
                return act.getAction();
            }
        }
        return null;
    }

    protected CompiledObject getCompiledObject(CompileProcessor p, String objectId) {
        WidgetObjectScope widgetObjectScope;
        if (objectId != null && (widgetObjectScope = (WidgetObjectScope)p.getScope(WidgetObjectScope.class)) != null && widgetObjectScope.containsKey(objectId)) {
            return widgetObjectScope.getObject(objectId);
        }
        return (CompiledObject)p.getScope(CompiledObject.class);
    }
}

