/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.dialog;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.global.view.page.N2oDialog;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.page.Dialog;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.N2oCompileProcessor;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.context.DialogContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class DialogCompiler
implements BaseSourceCompiler<Dialog, N2oDialog, DialogContext> {
    public Class<? extends Source> getSourceClass() {
        return N2oDialog.class;
    }

    public Dialog compile(N2oDialog source, DialogContext context, CompileProcessor p) {
        Dialog dialog = new Dialog();
        dialog.setTitle(source.getTitle());
        dialog.setDescription(source.getDescription());
        dialog.setSize((String)p.cast((Object)source.getSize(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.dialog.size"), String.class)), new Object[0]));
        CompiledObject object = (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(context.getObjectId()));
        if (source.getToolbar() != null) {
            source.getToolbar().getAllActions().stream().filter(N2oInvokeAction.class::isInstance).forEach(act -> ((N2oInvokeAction)act).setDoubleCloseOnSuccess(Boolean.valueOf(true)));
            String btnWidgetId = context.getParentWidgetId().substring(context.getParentPageId().length() + 1);
            Arrays.stream(source.getToolbar().getItems()).filter(N2oButton.class::isInstance).forEach(mi -> ((N2oButton)mi).setWidgetId(btnWidgetId));
            ToolbarPlaceScope toolbarPlaceScope = new ToolbarPlaceScope((String)p.resolve(Placeholders.property((String)"n2o.api.dialog.toolbar.place"), String.class));
            WidgetScope widgetScope = new WidgetScope();
            widgetScope.setClientWidgetId(context.getClientWidgetId());
            ParentRouteScope pageRouteScope = new ParentRouteScope(context.getRoute((N2oCompileProcessor)p), context.getPathRouteMapping(), context.getQueryRouteMapping());
            PageScope pageScope = new PageScope();
            pageScope.setPageId(context.getParentPageId());
            Toolbar toolbar = (Toolbar)p.compile((Object)source.getToolbar(), (CompileContext)context, new Object[]{new IndexScope(), widgetScope, object, pageRouteScope, toolbarPlaceScope, pageScope});
            dialog.setToolbar(toolbar);
        }
        return dialog;
    }
}

