/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.global.view.page.N2oLeftRightPage;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.StandardPage;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.PageWidgetsScope;
import org.springframework.stereotype.Component;

@Component
public class LeftRightPageCompiler
extends BasePageCompiler<N2oLeftRightPage, StandardPage> {
    public StandardPage compile(N2oLeftRightPage source, PageContext context, CompileProcessor p) {
        StandardPage page = new StandardPage();
        ArrayList<SourceComponent> allItems = new ArrayList<SourceComponent>();
        if (source.getLeft() != null) {
            allItems.addAll(Arrays.asList(source.getLeft()));
        }
        if (source.getRight() != null) {
            allItems.addAll(Arrays.asList(source.getRight()));
        }
        if (source.getLeftWidth() != null && !source.getLeftWidth().isEmpty() || source.getRightWidth() != null && !source.getRightWidth().isEmpty()) {
            StandardPage standardPage = page;
            Objects.requireNonNull(standardPage);
            page.setWidth(new StandardPage.RegionWidth(standardPage, source.getLeftWidth(), source.getRightWidth()));
        }
        return this.compilePage(source, page, context, p, allItems.toArray(new SourceComponent[0]), null);
    }

    @Override
    protected void initRegions(N2oLeftRightPage source, StandardPage page, CompileProcessor p, PageContext context, PageScope pageScope, PageRoutes pageRoutes, PageWidgetsScope pageWidgetsScope) {
        HashMap<String, List<Region>> regions = new HashMap<String, List<Region>>();
        IndexScope index = new IndexScope();
        this.initRegions(source.getLeft(), regions, "left", context, p, pageScope, pageRoutes, pageWidgetsScope, index);
        this.initRegions(source.getRight(), regions, "right", context, p, pageScope, pageRoutes, pageWidgetsScope, index);
        page.setRegions(regions);
    }

    public Class<? extends Source> getSourceClass() {
        return N2oLeftRightPage.class;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.page.left_right.src";
    }
}

