/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Submenu;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.BaseButtonCompiler;
import org.springframework.stereotype.Component;

@Component
public class SubmenuCompiler
extends BaseButtonCompiler<N2oSubmenu, Submenu>
implements MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oSubmenu.class;
    }

    public Submenu compile(N2oSubmenu source, CompileContext<?, ?> context, CompileProcessor p) {
        Submenu submenu = new Submenu();
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        this.initItem((AbstractButton)submenu, (N2oAbstractButton)source, idx, context, p);
        submenu.setId((String)(source.getId() == null ? "subMenu" + idx.get() : source.getId()));
        source.setId(submenu.getId());
        submenu.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.submenu.src"), String.class)), new Object[0]));
        submenu.setShowToggleIcon((Boolean)p.cast((Object)source.getShowToggleIcon(), (Object)true, new Object[0]));
        submenu.setVisible((Object)source.getVisible());
        this.initMenuItems(source, submenu, idx, context, p);
        this.initGenerate(source, submenu, idx, context, p);
        return submenu;
    }

    private void initMenuItems(N2oSubmenu source, Submenu button, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getMenuItems() != null) {
            button.setSubMenu(Stream.of(source.getMenuItems()).map(mi -> {
                PerformButton menuItem = (PerformButton)p.compile(mi, context, new Object[]{p, idx});
                menuItem.setColor(null);
                return menuItem;
            }).collect(Collectors.toList()));
        }
    }

    private void initGenerate(N2oSubmenu sub, Submenu button, IndexScope idx, CompileContext<?, ?> context, CompileProcessor p) {
        if (sub.getGenerate() != null) {
            if (button.getSubMenu() == null) {
                button.setSubMenu(new ArrayList());
            }
            for (String generate : sub.getGenerate()) {
                N2oToolbar source = (N2oToolbar)p.getScope(N2oToolbar.class);
                for (ToolbarItem toolbarItem : this.buttonGeneratorFactory.generate(generate.trim(), source, context, p)) {
                    PerformButton menuItem = (PerformButton)p.compile((Object)toolbarItem, context, new Object[]{p, idx});
                    menuItem.setColor(null);
                    button.getSubMenu().add(menuItem);
                }
            }
        }
    }
}

