/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oCopyAction;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.CopyMode;
import net.n2oapp.framework.api.metadata.meta.action.copy.CopyAction;
import net.n2oapp.framework.api.metadata.meta.action.copy.CopyActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.CompileUtil;
import org.springframework.stereotype.Component;

@Component
public class CopyActionCompiler
extends AbstractActionCompiler<CopyAction, N2oCopyAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oCopyAction.class;
    }

    public CopyAction compile(N2oCopyAction source, CompileContext<?, ?> context, CompileProcessor p) {
        CopyAction copyAction = new CopyAction();
        this.compileAction(copyAction, source, p);
        copyAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.copy.type"), String.class));
        String sourceWidgetId = this.getSourceWidgetId(source, context, p);
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        String sourceDatasource = pageScope == null || pageScope.getWidgetIdDatasourceMap() == null ? sourceWidgetId : pageScope.getWidgetIdDatasourceMap().get(sourceWidgetId);
        CopyActionPayload.ClientModel sourceModel = new CopyActionPayload.ClientModel(sourceDatasource, ((ReduxModel)p.cast((Object)source.getSourceModel(), (Object)ReduxModel.RESOLVE, new Object[0])).getId());
        if (source.getSourceFieldId() != null) {
            sourceModel.setField(source.getSourceFieldId());
        }
        String targetWidgetId = this.getTargetWidgetId(source, context, p);
        String targetDatasource = pageScope == null || pageScope.getWidgetIdDatasourceMap() == null ? targetWidgetId : pageScope.getWidgetIdDatasourceMap().get(targetWidgetId);
        CopyActionPayload.ClientModel targetModel = new CopyActionPayload.ClientModel(targetDatasource, ((ReduxModel)p.cast((Object)source.getTargetModel(), (Object)ReduxModel.RESOLVE, new Object[0])).getId());
        if (source.getTargetFieldId() != null) {
            targetModel.setField(source.getTargetFieldId());
        }
        ((CopyActionPayload)copyAction.getPayload()).setSource(sourceModel);
        ((CopyActionPayload)copyAction.getPayload()).setTarget(targetModel);
        ((CopyActionPayload)copyAction.getPayload()).setMode((CopyMode)p.cast((Object)source.getMode(), (Object)CopyMode.merge, new Object[0]));
        MetaSaga meta = new MetaSaga();
        Boolean closeLastModal = (Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.copy.close_on_success"), Boolean.class);
        meta.setModalsToClose(Integer.valueOf(closeLastModal != false ? 1 : 0));
        copyAction.setMeta(meta);
        return copyAction;
    }

    private String getSourceWidgetId(N2oCopyAction source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (source.getSourceWidgetId() != null) {
            return pageScope != null ? pageScope.getGlobalWidgetId(source.getSourceWidgetId()) : source.getSourceWidgetId();
        }
        return widgetScope == null ? this.initTargetWidget(context, p) : widgetScope.getClientWidgetId();
    }

    private String getTargetWidgetId(N2oCopyAction source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (source.getTargetWidgetId() != null) {
            if (source.getTargetClientPageId() != null) {
                return CompileUtil.generateWidgetId(source.getTargetClientPageId(), source.getTargetWidgetId());
            }
            return pageScope != null ? pageScope.getGlobalWidgetId(source.getTargetWidgetId()) : source.getTargetWidgetId();
        }
        return this.initTargetWidget(context, p);
    }
}

