/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.HashMap;
import java.util.Map;
import net.n2oapp.framework.api.metadata.event.action.UploadType;

public enum DefaultActions {
    create(false, false, true, "n2o.create", true, "fa fa-plus", "n2o.save", "n2o.page.creating", UploadType.defaults),
    update(true, true, "n2o.update", true, "fa fa-pencil", "n2o.save", "n2o.page.updating", UploadType.query),
    delete(true, false, "n2o.delete", false, "fa fa-trash");

    private static final Map<String, DefaultActions> actionsByNameMap;
    private boolean context;
    private boolean defaultAction;
    private boolean primary;
    private String label;
    private boolean modal;
    private String icon;
    private String formSubmitLabel;
    private String pageName;
    private UploadType upload;

    private DefaultActions(boolean context, boolean defaultAction, String label, boolean modal, String icon, String formSubmitLabel, String pageName, UploadType upload) {
        this.context = context;
        this.defaultAction = defaultAction;
        this.label = label;
        this.modal = modal;
        this.icon = icon;
        this.formSubmitLabel = formSubmitLabel;
        this.pageName = pageName;
        this.upload = upload;
    }

    private DefaultActions(boolean context, boolean defaultAction, boolean primary, String label, boolean modal, String icon, String formSubmitLabel, String pageName, UploadType upload) {
        this.context = context;
        this.defaultAction = defaultAction;
        this.primary = primary;
        this.label = label;
        this.modal = modal;
        this.icon = icon;
        this.formSubmitLabel = formSubmitLabel;
        this.pageName = pageName;
        this.upload = upload;
    }

    private DefaultActions(boolean context, boolean defaultAction, String label, boolean modal, String icon) {
        this.context = context;
        this.defaultAction = defaultAction;
        this.label = label;
        this.modal = modal;
        this.icon = icon;
    }

    public static DefaultActions get(String name) {
        return actionsByNameMap.get(name);
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean isContext() {
        return this.context;
    }

    public boolean isDefaultAction() {
        return this.defaultAction;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isModal() {
        return this.modal;
    }

    public String getFormSubmitLabel() {
        return this.formSubmitLabel;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public UploadType getUpload() {
        return this.upload;
    }

    static {
        actionsByNameMap = new HashMap<String, DefaultActions>();
        for (DefaultActions da : DefaultActions.values()) {
            actionsByNameMap.put(da.name(), da);
        }
    }
}

