/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.action;

import java.util.List;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.event.action.N2oInvokeAction;
import net.n2oapp.framework.api.metadata.global.dao.N2oParam;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeActionPayload;
import net.n2oapp.framework.api.metadata.meta.saga.AsyncMetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.MetaSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RedirectSaga;
import net.n2oapp.framework.api.metadata.meta.saga.RefreshSaga;
import net.n2oapp.framework.api.metadata.meta.widget.RequestMethod;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.action.AbstractActionCompiler;
import net.n2oapp.framework.config.metadata.compile.context.DialogContext;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class InvokeActionCompiler
extends AbstractActionCompiler<InvokeAction, N2oInvokeAction> {
    public Class<? extends Source> getSourceClass() {
        return N2oInvokeAction.class;
    }

    public InvokeAction compile(N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        InvokeAction invokeAction = new InvokeAction();
        this.compileAction(invokeAction, source, p);
        invokeAction.setOperationId(source.getOperationId());
        invokeAction.setType((String)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.type"), String.class));
        String targetWidgetId = this.initTargetWidget(context, p);
        ReduxModel targetWidgetModel = this.getTargetWidgetModel(p, ReduxModel.RESOLVE);
        ParentRouteScope routeScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String currentWidgetId = widgetScope == null ? targetWidgetId : widgetScope.getClientWidgetId();
        String datasource = pageScope == null || pageScope.getWidgetIdDatasourceMap() == null ? targetWidgetId : pageScope.getWidgetIdDatasourceMap().get(targetWidgetId);
        String modalLink = Redux.createBindLink(datasource, targetWidgetModel).getBindLink();
        ((InvokeActionPayload)invokeAction.getPayload()).setModelLink(modalLink);
        ((AsyncMetaSaga)invokeAction.getMeta()).setSuccess(this.initSuccessMeta(invokeAction, source, context, p, targetWidgetId, currentWidgetId, routeScope));
        ((AsyncMetaSaga)invokeAction.getMeta()).setFail(this.initFailMeta(invokeAction, source, context, p, currentWidgetId));
        ((InvokeActionPayload)invokeAction.getPayload()).setWidgetId(targetWidgetId);
        ((InvokeActionPayload)invokeAction.getPayload()).setModelId(datasource);
        if (widgetScope == null) {
            ((InvokeActionPayload)invokeAction.getPayload()).setPageId(pageScope.getPageId());
        }
        this.initDataProvider(invokeAction, source, context, p, targetWidgetModel, routeScope);
        return invokeAction;
    }

    private MetaSaga initFailMeta(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p, String currentWidgetId) {
        MetaSaga metaSaga = new MetaSaga();
        metaSaga.setMessageWidgetId(currentWidgetId);
        boolean closeOnFail = (Boolean)p.cast((Object)source.getCloseOnFail(), (Object)false, new Object[0]);
        if (closeOnFail && (context instanceof ModalPageContext || context instanceof DialogContext)) {
            metaSaga.setModalsToClose(Integer.valueOf(1));
        }
        return metaSaga;
    }

    private MetaSaga initSuccessMeta(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p, String targetWidgetId, String currentWidgetId, ParentRouteScope routeScope) {
        MetaSaga meta = new MetaSaga();
        boolean refresh = (Boolean)p.cast((Object)source.getRefreshOnSuccess(), (Object)true, new Object[0]);
        boolean redirect = source.getRedirectUrl() != null;
        boolean doubleCloseOnSuccess = (Boolean)p.cast((Object)source.getDoubleCloseOnSuccess(), (Object)false, new Object[0]);
        boolean closeOnSuccess = doubleCloseOnSuccess || (Boolean)p.cast((Object)source.getCloseOnSuccess(), (Object)false, new Object[0]) != false;
        String messageWidgetId = currentWidgetId;
        if (closeOnSuccess && context instanceof PageContext) {
            messageWidgetId = ((PageContext)context).getParentClientWidgetId();
        }
        meta.setMessageWidgetId(messageWidgetId);
        if (closeOnSuccess) {
            if (context instanceof ModalPageContext || context instanceof DialogContext) {
                meta.setModalsToClose(Integer.valueOf(doubleCloseOnSuccess ? 2 : 1));
            } else if (!redirect) {
                String backRoute = context instanceof PageContext ? ((PageContext)context).getParentRoute() : "/";
                meta.setRedirect(new RedirectSaga());
                meta.getRedirect().setPath(backRoute);
                meta.getRedirect().setTarget(Target.application);
            }
        }
        if (refresh) {
            meta.setRefresh(new RefreshSaga());
            meta.getRefresh().setType(RefreshSaga.Type.widget);
            String refreshWidgetId = messageWidgetId;
            if (source.getRefreshWidgetId() != null) {
                PageScope pageScope = (PageScope)p.getScope(PageScope.class);
                refreshWidgetId = pageScope == null ? source.getRefreshWidgetId() : pageScope.getGlobalWidgetId(source.getRefreshWidgetId());
            } else if (closeOnSuccess && context instanceof PageContext && ((PageContext)context).getRefreshClientWidgetId() != null) {
                refreshWidgetId = ((PageContext)context).getRefreshClientWidgetId();
            }
            meta.getRefresh().getOptions().setWidgetId(refreshWidgetId);
        }
        if (redirect) {
            if (context instanceof ModalPageContext || context instanceof DialogContext) {
                meta.setModalsToClose(Integer.valueOf(doubleCloseOnSuccess ? 2 : 1));
            }
            meta.setRedirect(new RedirectSaga());
            meta.getRedirect().setPath(RouteUtil.absolute(source.getRedirectUrl(), routeScope != null ? routeScope.getUrl() : null));
            meta.getRedirect().setTarget(source.getRedirectTarget());
            meta.getRedirect().setServer(true);
        }
        return meta;
    }

    private void initDataProvider(InvokeAction invokeAction, N2oInvokeAction source, CompileContext<?, ?> context, CompileProcessor p, ReduxModel model, ParentRouteScope routeScope) {
        CompiledObject compiledObject;
        InvokeActionPayload payload = (InvokeActionPayload)invokeAction.getPayload();
        N2oClientDataProvider dataProvider = new N2oClientDataProvider();
        dataProvider.setOptimistic((Boolean)p.cast((Object)source.getOptimistic(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.optimistic"), Boolean.class)), new Object[0]));
        dataProvider.setTargetModel(model);
        dataProvider.setTargetWidgetId(((InvokeActionPayload)invokeAction.getPayload()).getWidgetId());
        dataProvider.setId(source.getId());
        this.validatePathAndRoute(source, routeScope);
        dataProvider.setPathParams(source.getPathParams());
        dataProvider.setFormParams(source.getFormParams());
        dataProvider.setHeaderParams(source.getHeaderParams());
        dataProvider.setMethod((RequestMethod)p.cast((Object)source.getMethod(), (Object)((RequestMethod)p.resolve(Placeholders.property((String)"n2o.api.action.invoke.method"), RequestMethod.class)), new Object[0]));
        dataProvider.setUrl(source.getRoute());
        dataProvider.setSubmitForm((Boolean)p.cast((Object)source.getSubmitForm(), (Object)true, new Object[0]));
        CompiledObject compiledObject2 = compiledObject = source.getObjectId() == null ? (CompiledObject)p.getScope(CompiledObject.class) : (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId()));
        if (compiledObject == null) {
            throw new N2oException(String.format("For compilation action [%s] is necessary object!", source.getId()));
        }
        invokeAction.setObjectId(compiledObject.getId());
        AsyncMetaSaga metaSaga = (AsyncMetaSaga)invokeAction.getMeta();
        N2oClientDataProvider.ActionContextData actionContextData = new N2oClientDataProvider.ActionContextData();
        actionContextData.setObjectId(compiledObject.getId());
        actionContextData.setOperationId(source.getOperationId());
        actionContextData.setRedirect(this.initServerRedirect(metaSaga));
        actionContextData.setParentWidgetId(((InvokeActionPayload)invokeAction.getPayload()).getWidgetId());
        actionContextData.setFailAlertWidgetId(metaSaga.getFail().getMessageWidgetId());
        actionContextData.setMessagesForm(metaSaga.getFail().getMessageWidgetId());
        actionContextData.setSuccessAlertWidgetId(metaSaga.getSuccess().getMessageWidgetId());
        actionContextData.setMessageOnSuccess(((Boolean)p.cast((Object)source.getMessageOnSuccess(), (Object)true, new Object[0])).booleanValue());
        actionContextData.setMessageOnFail(((Boolean)p.cast((Object)source.getMessageOnFail(), (Object)true, new Object[0])).booleanValue());
        actionContextData.setMessagePosition(source.getMessagePosition());
        actionContextData.setMessagePlacement(source.getMessagePlacement());
        actionContextData.setOperation((CompiledObject.Operation)compiledObject.getOperations().get(source.getOperationId()));
        dataProvider.setActionContextData(actionContextData);
        ClientDataProvider compiledDataProvider = ClientDataProviderUtil.compile(dataProvider, context, p);
        if (routeScope != null && compiledDataProvider.getPathMapping() != null) {
            compiledDataProvider.getPathMapping().putAll(routeScope.getPathMapping());
        }
        payload.setDataProvider(compiledDataProvider);
    }

    private void validatePathAndRoute(N2oInvokeAction source, ParentRouteScope routeScope) {
        List<String> routeParams;
        String route = source.getRoute();
        N2oParam[] pathParams = source.getPathParams();
        List<String> list = routeParams = route == null ? null : RouteUtil.getParams(route);
        if (!(routeParams != null && !routeParams.isEmpty() || pathParams != null && pathParams.length != 0)) {
            return;
        }
        if (routeParams == null) {
            throw new N2oException(String.format("path-param \"%s\" not used in route", pathParams[0].getName()));
        }
        if (pathParams == null) {
            throw new N2oException(String.format("path-param \"%s\" for route \"%s\" not set", route, routeParams.get(0)));
        }
        for (N2oParam pathParam : pathParams) {
            if (!routeParams.contains(pathParam.getName())) {
                throw new N2oException(String.format("route \"%s\" not contains path-param \"%s\"", route, pathParam.getName()));
            }
            if (routeScope.getUrl() == null || !RouteUtil.getParams(routeScope.getUrl()).contains(pathParam.getName())) continue;
            throw new N2oException(String.format("param \"%s\" duplicate in parent url ", pathParam.getName()));
        }
    }

    private RedirectSaga initServerRedirect(AsyncMetaSaga meta) {
        if (meta != null && meta.getSuccess() != null && meta.getSuccess().getRedirect() != null && meta.getSuccess().getRedirect().isServer()) {
            return meta.getSuccess().getRedirect();
        }
        return null;
    }
}

