/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.application;

import net.n2oapp.framework.api.metadata.application.Application;
import net.n2oapp.framework.api.metadata.application.Footer;
import net.n2oapp.framework.api.metadata.application.Logo;
import net.n2oapp.framework.api.metadata.application.N2oApplication;
import net.n2oapp.framework.api.metadata.application.N2oFooter;
import net.n2oapp.framework.api.metadata.application.N2oSidebar;
import net.n2oapp.framework.api.metadata.application.NavigationLayout;
import net.n2oapp.framework.api.metadata.application.Side;
import net.n2oapp.framework.api.metadata.application.Sidebar;
import net.n2oapp.framework.api.metadata.application.SidebarState;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.header.Header;
import net.n2oapp.framework.api.metadata.header.N2oHeader;
import net.n2oapp.framework.api.metadata.header.SearchBar;
import net.n2oapp.framework.api.metadata.header.SimpleMenu;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.context.ApplicationContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCompiler
implements BaseSourceCompiler<Application, N2oApplication, ApplicationContext>,
SourceClassAware {
    public Application compile(N2oApplication source, ApplicationContext context, CompileProcessor p) {
        Application application = new Application();
        this.initWelcomePage(source, p);
        Application.Layout layout = new Application.Layout();
        layout.setFixed((Boolean)p.cast((Object)source.getNavigationLayoutFixed(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.navigationLayout.fixed"), Boolean.class)), new Object[0]));
        layout.setFullSizeHeader(Boolean.valueOf(source.getNavigationLayout() == null || source.getNavigationLayout().equals((Object)NavigationLayout.fullSizeHeader)));
        application.setLayout(layout);
        Header header = this.initHeader(source.getHeader(), context, p);
        application.setHeader(header);
        application.setSidebar(this.initSidebar(source.getSidebar(), header, context, p));
        application.setFooter(this.initFooter(source.getFooter(), p));
        return application;
    }

    private Header initHeader(N2oHeader source, ApplicationContext context, CompileProcessor p) {
        if (source == null) {
            return null;
        }
        Header header = new Header();
        header.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.header.src"), String.class)), new Object[0]));
        header.setClassName(source.getCssClass());
        header.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        Logo logo = new Logo();
        logo.setTitle(source.getTitle());
        logo.setSrc(source.getLogoSrc());
        logo.setHref(source.getHomePageUrl());
        header.setLogo(logo);
        header.setMenu(source.getMenu() != null ? (SimpleMenu)p.compile((Object)source.getMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        header.setExtraMenu(source.getExtraMenu() != null ? (SimpleMenu)p.compile((Object)source.getExtraMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        header.setSearch(source.getSearchBar() != null ? (SearchBar)p.compile((Object)source.getSearchBar(), (CompileContext)context, new Object[0]) : null);
        if (source.getSidebarIcon() != null || source.getSidebarToggledIcon() != null) {
            Header.SidebarSwitcher sidebarSwitcher = new Header.SidebarSwitcher();
            sidebarSwitcher.setIcon(source.getSidebarIcon());
            sidebarSwitcher.setToggledIcon(source.getSidebarToggledIcon());
            header.setSidebarSwitcher(sidebarSwitcher);
        }
        return header;
    }

    private Sidebar initSidebar(N2oSidebar source, Header header, ApplicationContext context, CompileProcessor p) {
        if (source == null || source.getVisible() != null && !source.getVisible().booleanValue()) {
            return null;
        }
        Sidebar sidebar = new Sidebar();
        sidebar.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.sidebar.src"), String.class)), new Object[0]));
        sidebar.setClassName(source.getCssClass());
        sidebar.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        Logo logo = new Logo();
        logo.setTitle(source.getTitle());
        logo.setSrc(source.getLogoSrc());
        logo.setHref(source.getHomePageUrl());
        logo.setClassName(source.getLogoClass());
        sidebar.setLogo(logo);
        sidebar.setMenu(source.getMenu() != null ? (SimpleMenu)p.compile((Object)source.getMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        sidebar.setExtraMenu(source.getExtraMenu() != null ? (SimpleMenu)p.compile((Object)source.getExtraMenu(), (CompileContext)context, new Object[0]) : new SimpleMenu());
        sidebar.setSide((Side)p.cast((Object)source.getSide(), (Object)((Side)p.resolve(Placeholders.property((String)"n2o.api.sidebar.side"), Side.class)), new Object[0]));
        if (header != null && header.getSidebarSwitcher() != null) {
            sidebar.setDefaultState((SidebarState)p.cast((Object)source.getDefaultState(), (Object)SidebarState.none, new Object[0]));
            sidebar.setToggledState((SidebarState)p.cast((Object)source.getToggledState(), (Object)SidebarState.maxi, new Object[0]));
        } else {
            sidebar.setDefaultState((SidebarState)p.cast((Object)source.getDefaultState(), (Object)SidebarState.maxi, new Object[0]));
            sidebar.setToggledState((SidebarState)p.cast((Object)source.getToggledState(), (Object)(SidebarState.maxi.equals((Object)sidebar.getDefaultState()) ? SidebarState.mini : SidebarState.maxi), new Object[]{SidebarState.class}));
        }
        sidebar.setOverlay((Boolean)p.cast((Object)source.getOverlay(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.sidebar.overlay"), Boolean.class)), new Object[0]));
        sidebar.setToggleOnHover((Boolean)p.cast((Object)source.getToggleOnHover(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.sidebar.toggle_on_hover"), Boolean.class)), new Object[0]));
        return sidebar;
    }

    private Footer initFooter(N2oFooter source, CompileProcessor p) {
        if (source == null || source.getVisible() != null && !source.getVisible().booleanValue()) {
            return null;
        }
        Footer footer = new Footer();
        footer.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.footer.src"), String.class)), new Object[0]));
        footer.setClassName(source.getCssClass());
        footer.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        footer.setTextRight(source.getRightText());
        footer.setTextLeft(source.getLeftText());
        return footer;
    }

    private void initWelcomePage(N2oApplication source, CompileProcessor p) {
        String welcomePageId = source.getWelcomePageId() != null ? source.getWelcomePageId() : (String)p.resolve(Placeholders.property((String)"n2o.homepage.id"), String.class);
        PageContext context = new PageContext(welcomePageId, "/");
        p.addRoute((CompileContext)context);
    }

    public Class<N2oApplication> getSourceClass() {
        return N2oApplication.class;
    }
}

