/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Map;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.PreFiltersAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.plain.N2oAutoComplete;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.control.AutoComplete;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.StandardFieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.util.FieldCompileUtil;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;
import org.springframework.stereotype.Component;

@Component
public class AutoCompleteCompiler
extends StandardFieldCompiler<AutoComplete, N2oAutoComplete> {
    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.auto_complete.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oAutoComplete.class;
    }

    public StandardField<AutoComplete> compile(N2oAutoComplete source, CompileContext<?, ?> context, CompileProcessor p) {
        AutoComplete autoComplete = new AutoComplete();
        autoComplete.setPlaceholder(p.resolveJS(source.getPlaceholder()));
        autoComplete.setValueFieldId((String)p.cast((Object)source.getValueFieldId(), (Object)"name", new Object[0]));
        autoComplete.setTags((Boolean)p.cast((Object)source.getTags(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.auto_complete.tags"), Boolean.class)), new Object[0]));
        autoComplete.setMaxTagTextLength((Integer)p.cast((Object)source.getMaxTagTextLength(), (Object)((Integer)p.resolve(Placeholders.property((String)"n2o.api.control.input.select.max_tag_text_length"), Integer.class)), new Object[0]));
        if (source.getQueryId() != null) {
            autoComplete.setDataProvider(this.compileDataProvider(source, context, p));
        } else if (source.getOptions() != null) {
            ArrayList<DataSet> list = new ArrayList<DataSet>();
            for (Map option : source.getOptions()) {
                DataSet dataItem = new DataSet();
                option.forEach((f, v) -> dataItem.put(f, p.resolve(v)));
                list.add(dataItem);
            }
            autoComplete.setData(list);
        }
        return this.compileStandardField(autoComplete, source, context, p);
    }

    private ClientDataProvider compileDataProvider(N2oAutoComplete source, CompileContext<?, ?> context, CompileProcessor p) {
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromField(source.getPreFilters(), source.getQueryId(), p);
        dataProvider.setQuickSearchParam((String)p.cast((Object)source.getSearchFilterId(), (Object)"name", new Object[0]));
        source.addDependencies(FieldCompileUtil.getResetOnChangeDependency((PreFiltersAware)source));
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }
}

