/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.data.validation.ConditionValidation;
import net.n2oapp.framework.api.data.validation.ConstraintValidation;
import net.n2oapp.framework.api.data.validation.MandatoryValidation;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.event.action.UploadType;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.validation.N2oValidation;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.CompiledQuery;
import net.n2oapp.framework.api.metadata.local.view.widget.util.SubModelQuery;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.ReduxAction;
import net.n2oapp.framework.api.metadata.meta.control.ControlDependency;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.control.FetchValueDependency;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.WidgetParamScope;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentCompiler;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetVisibilityScope;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;
import net.n2oapp.framework.config.metadata.compile.widget.CopiedFieldScope;
import net.n2oapp.framework.config.metadata.compile.widget.FiltersScope;
import net.n2oapp.framework.config.metadata.compile.widget.ModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.MomentScope;
import net.n2oapp.framework.config.metadata.compile.widget.SubModelsScope;
import net.n2oapp.framework.config.metadata.compile.widget.UploadScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.CompileUtil;
import net.n2oapp.framework.config.util.ControlFilterUtil;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;

public abstract class FieldCompiler<D extends Field, S extends N2oField>
extends ComponentCompiler<D, S, CompileContext<?, ?>> {
    @Override
    protected String getSrcProperty() {
        return "n2o.api.field.src";
    }

    protected void compileField(D field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        this.compileComponent(field, source, context, p);
        field.setId(source.getId());
        this.compileCondition(source, () -> source.getVisible(), (N2oField.Dependency)new N2oField.VisibilityDependency(), arg_0 -> field.setVisible(arg_0), !"false".equals(source.getVisible()));
        this.compileCondition(source, () -> source.getEnabled(), (N2oField.Dependency)new N2oField.EnablingDependency(), arg_0 -> field.setEnabled(arg_0), !"false".equals(source.getEnabled()));
        this.compileCondition(source, () -> source.getRequired(), (N2oField.Dependency)new N2oField.RequiringDependency(), arg_0 -> field.setRequired(arg_0), "true".equals(source.getRequired()));
        this.compileFieldToolbar(field, source, context, p);
        field.setLabel(this.initLabel(source, p));
        field.setNoLabelBlock((Boolean)p.cast((Object)source.getNoLabelBlock(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.field.no_label_block"), Boolean.class)), new Object[0]));
        field.setLabelClass(p.resolveJS(source.getLabelClass()));
        field.setHelp(p.resolveJS(source.getHelp()));
        field.setDescription(p.resolveJS(source.getDescription()));
        field.setClassName(p.resolveJS(source.getCssClass()));
        this.compileDependencies((Field)field, source, context, p);
    }

    private void compileCondition(S source, Supplier<String> conditionGetter, N2oField.Dependency dependency, Consumer<Boolean> conditionSetter, Boolean defaultValue) {
        if (StringUtils.isLink((Object)conditionGetter.get())) {
            conditionSetter.accept(false);
            Set onFields = ScriptProcessor.extractVars((String)conditionGetter.get());
            dependency.setValue(StringUtils.unwrapLink((String)conditionGetter.get()));
            dependency.setOn((String[])onFields.toArray(String[]::new));
            source.addDependency(dependency);
        } else if (conditionGetter.get() != null) {
            conditionSetter.accept(defaultValue);
            dependency.setValue(conditionGetter.get());
            source.addDependency(dependency);
        } else {
            conditionSetter.accept(defaultValue);
        }
    }

    protected String initLabel(S source, CompileProcessor p) {
        if (!Boolean.TRUE.equals(source.getNoLabelBlock()) || !Boolean.TRUE.equals(source.getNoLabel())) {
            return p.resolveJS(source.getLabel());
        }
        return null;
    }

    protected void compileDependencies(Field field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getDependencies() != null) {
            for (N2oField.Dependency d : source.getDependencies()) {
                FetchValueDependency dependency = d instanceof N2oField.FetchValueDependency ? this.compileFetchDependency(d, context, p) : this.compileControlDependency(field, d, p);
                this.addToField((ControlDependency)dependency, field, d, p);
            }
        }
        if (source.getDependsOn() != null) {
            ControlDependency dependency = new ControlDependency();
            List<String> ons = Arrays.asList(source.getDependsOn());
            ons.replaceAll(String::trim);
            dependency.setOn(ons);
            dependency.setType(ValidationType.reRender);
            field.addDependency(dependency);
        }
    }

    private void addToField(ControlDependency compiled, Field field, N2oField.Dependency source, CompileProcessor p) {
        compiled.setApplyOnInit((Boolean)p.cast((Object)source.getApplyOnInit(), (Object)true, new Object[0]));
        if (source.getOn() != null) {
            List<String> ons = Arrays.asList(source.getOn());
            ons.replaceAll(String::trim);
            compiled.getOn().addAll(ons);
        }
        field.addDependency(compiled);
    }

    private void compileFieldToolbar(D field, S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getToolbar() != null) {
            Toolbar toolbar = (Toolbar)p.compile((Object)source.getToolbar(), context, new Object[0]);
            field.setToolbar((Group[])toolbar.getGroups().toArray(Group[]::new));
        }
    }

    private ControlDependency compileControlDependency(Field field, N2oField.Dependency d, CompileProcessor p) {
        ControlDependency dependency = new ControlDependency();
        if (d instanceof N2oField.EnablingDependency) {
            dependency.setType(ValidationType.enabled);
        } else if (d instanceof N2oField.RequiringDependency) {
            dependency.setType(ValidationType.required);
        } else if (d instanceof N2oField.VisibilityDependency) {
            dependency.setType(ValidationType.visible);
            Boolean isResettable = (Boolean)p.cast((Object)((N2oField.VisibilityDependency)d).getReset(), (Object)((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.visibility.auto_reset"), Boolean.class)), new Object[0]);
            if (Boolean.TRUE.equals(isResettable)) {
                ControlDependency reset = new ControlDependency();
                reset.setType(ValidationType.reset);
                reset.setExpression(ScriptProcessor.resolveFunction((String)d.getValue()));
                this.addToField(reset, field, d, p);
            }
        } else if (d instanceof N2oField.SetValueDependency) {
            dependency.setType(ValidationType.setValue);
        } else if (d instanceof N2oField.FetchDependency) {
            dependency.setType(ValidationType.fetch);
        } else if (d instanceof N2oField.ResetDependency) {
            dependency.setType(ValidationType.reset);
            if (d.getValue() == null) {
                d.setValue(String.valueOf(Boolean.TRUE));
            }
        }
        dependency.setExpression(ScriptProcessor.resolveFunction((String)d.getValue()));
        return dependency;
    }

    private FetchValueDependency compileFetchDependency(N2oField.Dependency d, CompileContext<?, ?> context, CompileProcessor p) {
        FetchValueDependency dependency = new FetchValueDependency();
        dependency.setType(ValidationType.fetchValue);
        dependency.setValueFieldId((String)p.cast((Object)((N2oField.FetchValueDependency)d).getValueFieldId(), (Object)"name", new Object[0]));
        dependency.setDataProvider(this.compileFetchDependencyDataProvider((N2oField.FetchValueDependency)d, context, p));
        return dependency;
    }

    private ClientDataProvider compileFetchDependencyDataProvider(N2oField.FetchValueDependency field, CompileContext<?, ?> context, CompileProcessor p) {
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromField(field.getPreFilters(), field.getQueryId(), p);
        dataProvider.setSize(field.getSize());
        return ClientDataProviderUtil.compile(dataProvider, context, p);
    }

    protected void compileFilters(S source, CompileProcessor p) {
        FiltersScope filtersScope = (FiltersScope)p.getScope(FiltersScope.class);
        if (filtersScope != null) {
            CompiledQuery query = (CompiledQuery)p.getScope(CompiledQuery.class);
            if (query == null) {
                return;
            }
            WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
            List<N2oQuery.Filter> filters = ControlFilterUtil.getFilters(source.getId(), query);
            filters.forEach(f -> {
                Filter filter = new Filter();
                filter.setFilterId(f.getFilterField());
                filter.setParam((String)p.cast((Object)source.getParam(), (Object)(widgetScope.getWidgetId() + "_" + f.getParam()), new Object[0]));
                filter.setRoutable(Boolean.valueOf(true));
                SubModelQuery subModelQuery = this.findSubModelQuery(source.getId(), p);
                ModelLink link = new ModelLink(ReduxModel.FILTER, widgetScope.getClientWidgetId());
                link.setSubModelQuery(subModelQuery);
                link.setValue((Object)p.resolveJS(Placeholders.ref((String)f.getFilterField())));
                link.setParam(filter.getParam());
                link.setObserve(true);
                filter.setLink(link);
                filtersScope.addFilter(filter);
            });
        }
    }

    protected SubModelQuery findSubModelQuery(String fieldId, CompileProcessor p) {
        if (fieldId == null) {
            return null;
        }
        SubModelsScope subModelsScope = (SubModelsScope)p.getScope(SubModelsScope.class);
        if (subModelsScope != null) {
            return subModelsScope.stream().filter(subModelQuery -> fieldId.equals(subModelQuery.getSubModel())).findAny().orElse(null);
        }
        return null;
    }

    protected void initValidations(S source, Field field, CompileContext<?, ?> context, CompileProcessor p) {
        MandatoryValidation mandatory;
        String REQUIRED_MESSAGE;
        ArrayList<Validation> serverValidations = new ArrayList<Validation>();
        ArrayList<Validation> clientValidations = new ArrayList<Validation>();
        Set visibilityConditions = (Set)p.getScope(FieldSetVisibilityScope.class);
        MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
        String string = REQUIRED_MESSAGE = momentScope != null && N2oValidation.ServerMoment.beforeQuery.equals((Object)momentScope.getMoment()) ? "n2o.required.filter" : "n2o.required.field";
        if ("true".equals(source.getRequired())) {
            mandatory = new MandatoryValidation(source.getId(), p.getMessage(REQUIRED_MESSAGE, new Object[0]), field.getId());
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.VisibilityDependency.class));
            mandatory.addEnablingConditions((Collection)visibilityConditions);
            serverValidations.add((Validation)mandatory);
            clientValidations.add((Validation)mandatory);
            field.setRequired(Boolean.valueOf(true));
        } else if (source.containsDependency(N2oField.RequiringDependency.class)) {
            mandatory = new MandatoryValidation(source.getId(), p.getMessage(REQUIRED_MESSAGE, new Object[0]), field.getId());
            if (momentScope != null) {
                mandatory.setMoment(momentScope.getMoment());
            }
            mandatory.addEnablingConditions((Collection)visibilityConditions);
            mandatory.addEnablingConditions(this.collectConditions(source, N2oField.RequiringDependency.class, N2oField.VisibilityDependency.class));
            mandatory.setEnablingExpression(ScriptProcessor.resolveFunction((String)ScriptProcessor.and(this.collectConditions(source, N2oField.RequiringDependency.class))));
            if (mandatory.getEnablingConditions() != null && !mandatory.getEnablingConditions().isEmpty()) {
                serverValidations.add((Validation)mandatory);
                clientValidations.add((Validation)mandatory);
            }
        }
        CompiledObject object = (CompiledObject)p.getScope(CompiledObject.class);
        this.initInlineValidations(field, source, serverValidations, clientValidations, object, context, visibilityConditions, p);
        field.setServerValidations(serverValidations.isEmpty() ? null : serverValidations);
        field.setClientValidations(clientValidations.isEmpty() ? null : clientValidations);
    }

    private void initInlineValidations(Field field, S source, List<Validation> serverValidations, List<Validation> clientValidations, CompiledObject object, CompileContext<?, ?> context, Set<String> visibilityConditions, CompileProcessor p) {
        N2oField.Validations validations = source.getValidations();
        if (validations == null) {
            return;
        }
        if (validations.getWhiteList() != null) {
            for (String validation : validations.getWhiteList()) {
                this.initWhiteListValidation(field.getId(), validation, source, serverValidations, clientValidations, object, visibilityConditions);
            }
        }
        if (validations.getInlineValidations() != null) {
            ArrayList<String> enablingConditions = new ArrayList<String>();
            if (source.getDependencies() != null) {
                for (N2oField.Dependency dependency : source.getDependencies()) {
                    if (!dependency.getClass().equals(N2oField.VisibilityDependency.class)) continue;
                    enablingConditions.add(dependency.getValue());
                }
            }
            ArrayList<Validation> objectValidations = new ArrayList<Validation>();
            for (N2oValidation v : validations.getInlineValidations()) {
                v.setFieldId(field.getId());
                Validation compiledValidation = (Validation)p.compile((Object)v, context, new Object[0]);
                MomentScope momentScope = (MomentScope)p.getScope(MomentScope.class);
                if (momentScope != null) {
                    compiledValidation.setMoment(momentScope.getMoment());
                }
                if ("false".equals(source.getVisible())) continue;
                if (!enablingConditions.isEmpty()) {
                    compiledValidation.addEnablingConditions(enablingConditions);
                }
                compiledValidation.addEnablingConditions(visibilityConditions);
                objectValidations.add(compiledValidation);
                serverValidations.add(compiledValidation);
                if (compiledValidation.getSide() != null && !compiledValidation.getSide().contains("client")) continue;
                clientValidations.add(compiledValidation);
            }
            if (object != null) {
                object.getValidations().addAll(objectValidations);
            }
        }
    }

    private void initWhiteListValidation(String fieldId, String refId, S source, List<Validation> serverValidations, List<Validation> clientValidations, CompiledObject object, Set<String> visibilityConditions) {
        if (object == null) {
            throw new N2oException(String.format("Field %s have validation reference, but haven't object!", fieldId));
        }
        Validation objectValidation = null;
        if (object.getValidationsMap() != null && object.getValidationsMap().containsKey(refId)) {
            objectValidation = (Validation)object.getValidationsMap().get(refId);
        } else if (object.getOperations() != null && !object.getOperations().isEmpty()) {
            for (CompiledObject.Operation operation : object.getOperations().values()) {
                Optional<Validation> result = operation.getValidationList().stream().filter(v -> v.getId().equals(refId)).findFirst();
                if (!result.isPresent()) continue;
                objectValidation = result.get();
                break;
            }
        }
        if (objectValidation == null) {
            throw new N2oException(String.format("Field %s contains validation reference for nonexistent validation!", fieldId));
        }
        ConstraintValidation validation = null;
        if (objectValidation instanceof ConstraintValidation) {
            validation = new ConstraintValidation((ConstraintValidation)objectValidation);
        } else if (objectValidation instanceof ConditionValidation) {
            validation = new ConditionValidation((ConditionValidation)objectValidation);
        } else if (objectValidation instanceof MandatoryValidation) {
            validation = new MandatoryValidation((MandatoryValidation)objectValidation);
        }
        if (validation == null) {
            return;
        }
        ArrayList<String> enablingConditions = new ArrayList<String>();
        if (source.getDependencies() != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                if (!(dependency instanceof N2oField.VisibilityDependency)) continue;
                enablingConditions.add(dependency.getValue());
            }
        }
        validation.setFieldId(fieldId);
        validation.addEnablingConditions(enablingConditions);
        validation.addEnablingConditions(visibilityConditions);
        if (validation.getSide() == null || validation.getSide().equals("client,server")) {
            serverValidations.add((Validation)validation);
            clientValidations.add((Validation)validation);
        } else if (validation.getSide().equals("client")) {
            clientValidations.add((Validation)validation);
        } else if (validation.getSide().equals("server")) {
            serverValidations.add((Validation)validation);
        }
    }

    private List<String> collectConditions(S source, Class ... types) {
        ArrayList<String> result = new ArrayList<String>();
        if (source.getDependencies() != null && types != null) {
            for (N2oField.Dependency dependency : source.getDependencies()) {
                for (Class clazz : types) {
                    if (!dependency.getClass().equals(clazz)) continue;
                    result.add(dependency.getValue());
                }
            }
        }
        return result.isEmpty() ? null : result;
    }

    protected void compileCopied(S source, CompileProcessor p) {
        CopiedFieldScope scope;
        if (Boolean.TRUE.equals(source.getCopied()) && (scope = (CopiedFieldScope)p.getScope(CopiedFieldScope.class)) != null) {
            scope.addCopiedFields(source.getId());
        }
    }

    protected void compileDefaultValues(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        UploadScope uploadScope = (UploadScope)p.getScope(UploadScope.class);
        WidgetParamScope paramScope = (WidgetParamScope)p.getScope(WidgetParamScope.class);
        if (paramScope != null) {
            this.compileParams(control, source, paramScope, p);
        }
        if (uploadScope != null && !UploadType.defaults.equals((Object)uploadScope.getUpload()) && Boolean.TRUE.equals(source.getCopied())) {
            return;
        }
        ModelsScope defaultValues = (ModelsScope)p.getScope(ModelsScope.class);
        if (defaultValues != null && defaultValues.hasModels()) {
            Object defValue = source.getDefaultValue() != null ? p.resolve(source.getDefaultValue(), source.getDomain()) : this.compileDefValues(source, p);
            if (defValue != null) {
                if (defValue instanceof String) {
                    defValue = ScriptProcessor.resolveExpression((String)((String)defValue));
                }
                if (StringUtils.isJs((Object)defValue)) {
                    ModelLink defaultValue = this.getDefaultValueModelLink(source, control.getId(), defaultValues, context, p);
                    if (source.getRefFieldId() == null) {
                        defaultValue.setValue(defValue);
                    }
                    defaultValue.setParam(source.getParam());
                    defaultValues.add(control.getId(), defaultValue);
                } else {
                    Map values;
                    SubModelQuery subModelQuery = this.findSubModelQuery(control.getId(), p);
                    ModelLink modelLink = this.getDefaultValueModelLink(source, control.getId(), defaultValues, context, p);
                    if (defValue instanceof DefaultValues && (values = ((DefaultValues)defValue).getValues()) != null) {
                        for (String param : values.keySet()) {
                            Object value;
                            if (!(values.get(param) instanceof String) || (value = ScriptProcessor.resolveExpression((String)((String)values.get(param)))) == null) continue;
                            values.put(param, value);
                        }
                    }
                    modelLink.setValue(defValue);
                    modelLink.setSubModelQuery(subModelQuery);
                    String param = source.getParam() != null ? source.getParam() : defaultValues.getWidgetId() + "_" + control.getId();
                    modelLink.setParam(param);
                    defaultValues.add(control.getId(), modelLink);
                }
            } else if (source.getRefPage() != null || source.getRefWidgetId() != null || source.getRefFieldId() != null) {
                ModelLink modelLink = this.getDefaultValueModelLink(source, control.getId(), defaultValues, context, p);
                modelLink.setParam(source.getParam());
                defaultValues.add(control.getId(), modelLink);
            }
        }
    }

    protected Object compileDefValues(S source, CompileProcessor p) {
        return null;
    }

    protected void compileParams(D control, S source, WidgetParamScope paramScope, CompileProcessor p) {
        ModelsScope modelsScope;
        if (source.getParam() != null && (modelsScope = (ModelsScope)p.getScope(ModelsScope.class)) != null) {
            ModelLink onSet = new ModelLink(modelsScope.getModel(), modelsScope.getWidgetId(), control.getId());
            onSet.setParam(source.getParam());
            ReduxAction onGet = Redux.dispatchUpdateModel(modelsScope.getWidgetId(), modelsScope.getModel(), control.getId(), Placeholders.colon((String)source.getParam()));
            paramScope.addQueryMapping(source.getParam(), onGet, (BindLink)onSet);
        }
    }

    private ModelLink getDefaultValueModelLink(S source, String fieldId, ModelsScope defaultModelScope, CompileContext<?, ?> context, CompileProcessor p) {
        ModelLink defaultValue;
        String datasource = this.getDefaultValueLinkDatasourceId(source, fieldId, defaultModelScope.getWidgetId(), context, p);
        if (source.getRefFieldId() != null) {
            defaultValue = new ModelLink((ReduxModel)p.cast((Object)source.getRefModel(), (Object)defaultModelScope.getModel(), new Object[]{ReduxModel.RESOLVE}), datasource, source.getRefFieldId());
        } else {
            defaultValue = new ModelLink((ReduxModel)p.cast((Object)source.getRefModel(), (Object)defaultModelScope.getModel(), new Object[]{ReduxModel.RESOLVE}), datasource);
            defaultValue.setValue((Object)p.resolveJS(source.getDefaultValue()));
        }
        if (N2oField.Page.THIS.equals((Object)source.getRefPage())) {
            defaultValue.setObserve(true);
        }
        return defaultValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDefaultValueLinkDatasourceId(S source, String fieldId, String defaultWidgetId, CompileContext<?, ?> context, CompileProcessor p) {
        if (N2oField.Page.PARENT.equals((Object)source.getRefPage())) {
            if (!(context instanceof PageContext)) throw new N2oException(String.format("Field %s has ref-page=\"parent\" but PageContext not found", fieldId));
            return source.getRefWidgetId() == null ? ((PageContext)context).getParentClientWidgetId() : CompileUtil.generateWidgetId(((PageContext)context).getParentClientPageId(), source.getRefWidgetId());
        }
        PageScope scope = (PageScope)p.getScope(PageScope.class);
        return source.getRefWidgetId() == null ? scope.getWidgetIdDatasourceMap().get(defaultWidgetId) : scope.getWidgetIdDatasourceMap().get(scope.getGlobalWidgetId(source.getRefWidgetId()));
    }
}

