/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.list.N2oSlider;
import net.n2oapp.framework.api.metadata.meta.control.Slider;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.control.ListControlCompiler;
import org.springframework.stereotype.Component;

@Component
public class SliderCompiler
extends ListControlCompiler<Slider, N2oSlider> {
    public Class<? extends Source> getSourceClass() {
        return N2oSlider.class;
    }

    public StandardField<Slider> compile(N2oSlider source, CompileContext<?, ?> context, CompileProcessor p) {
        Slider slider = new Slider();
        slider.setMultiple(Boolean.valueOf(N2oSlider.Mode.range.equals((Object)source.getMode())));
        boolean isVertical = Boolean.TRUE.equals(source.getVertical());
        slider.setVertical(Boolean.valueOf(isVertical));
        slider.setShowTooltip((Boolean)p.resolve(Placeholders.property((String)"n2o.api.control.slider.tooltip"), Boolean.class));
        slider.setTooltipPlacement(isVertical ? "left" : "top");
        slider.setTooltipFormatter("${this}" + (String)p.cast((Object)source.getMeasure(), (Object)"", new Object[0]));
        slider.setMin(source.getMin());
        slider.setMax(source.getMax());
        slider.setStep((Integer)p.cast((Object)source.getStep(), (Object)1, new Object[0]));
        return this.compileListControl(slider, source, context, p);
    }

    @Override
    protected String getControlSrcProperty() {
        return "n2o.api.control.slider.src";
    }
}

