/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.control;

import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.control.N2oStandardField;
import net.n2oapp.framework.api.metadata.dataprovider.N2oClientDataProvider;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.ClientDataProvider;
import net.n2oapp.framework.api.metadata.meta.control.Control;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.control.StandardField;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.control.FieldCompiler;
import net.n2oapp.framework.config.metadata.compile.dataprovider.ClientDataProviderUtil;
import net.n2oapp.framework.config.metadata.compile.fieldset.FieldSetScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.N2oClientDataProviderUtil;
import net.n2oapp.framework.config.util.StylesResolver;

public abstract class StandardFieldCompiler<D extends Control, S extends N2oStandardField>
extends FieldCompiler<StandardField<D>, S> {
    protected StandardField<D> compileStandardField(D control, S source, CompileContext<?, ?> context, CompileProcessor p) {
        StandardField field = new StandardField();
        if (control.getSrc() == null) {
            control.setSrc(source.getSrc());
        }
        source.setSrc(null);
        this.compileField(field, source, context, p);
        field.setControl(control);
        field.setClassName(null);
        this.initValidations(source, (Field)field, context, p);
        this.compileFilters(source, p);
        this.compileCopied(source, p);
        this.compileControl(control, source, p, field, context);
        control.setProperties(field.getProperties());
        field.setProperties(null);
        field.setDataProvider(this.initDataProvider(source, context, p));
        return field;
    }

    protected void compileControl(D control, S source, CompileProcessor p, StandardField<D> field, CompileContext<?, ?> context) {
        control.setSrc((String)p.cast((Object)control.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)this.getControlSrcProperty()), String.class)), new Object[0]));
        if (control.getSrc() == null) {
            throw new N2oException("control src is required");
        }
        control.setId(source.getId());
        control.setClassName(p.resolveJS(source.getCssClass()));
        control.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        this.compileDefaultValues(field, source, context, p);
    }

    @Override
    protected String initLabel(S source, CompileProcessor p) {
        if (!Boolean.TRUE.equals(source.getNoLabel())) {
            String label = super.initLabel(source, p);
            FieldSetScope scope = (FieldSetScope)p.getScope(FieldSetScope.class);
            if (label == null && scope != null) {
                label = (String)scope.get(source.getId());
            }
            if (label == null) {
                label = source.getId();
            }
            return label;
        }
        return null;
    }

    protected abstract String getControlSrcProperty();

    private ClientDataProvider initDataProvider(S source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getSubmit() == null) {
            return null;
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        String id = widgetScope != null ? widgetScope.getWidgetId() : source.getId();
        N2oClientDataProvider dataProvider = N2oClientDataProviderUtil.initFromSubmit(source.getSubmit(), id, (CompiledObject)p.getScope(CompiledObject.class), p);
        dataProvider.setSubmitForm(Boolean.valueOf(false));
        if (widgetScope != null) {
            dataProvider.getActionContextData().setParentWidgetId(widgetScope.getClientWidgetId());
            dataProvider.getActionContextData().setSuccessAlertWidgetId(widgetScope.getClientWidgetId());
            dataProvider.getActionContextData().setFailAlertWidgetId(widgetScope.getClientWidgetId());
        }
        ClientDataProvider clientDataProvider = ClientDataProviderUtil.compile(dataProvider, context, p);
        ParentRouteScope parentRouteScope = (ParentRouteScope)p.getScope(ParentRouteScope.class);
        if (parentRouteScope != null) {
            clientDataProvider.getPathMapping().putAll(parentRouteScope.getPathMapping());
        }
        return clientDataProvider;
    }
}

