/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.fieldset;

import java.util.ArrayList;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceComponent;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldSet;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oFieldsetColumn;
import net.n2oapp.framework.api.metadata.global.view.fieldset.N2oSetFieldSet;
import net.n2oapp.framework.api.metadata.meta.control.Field;
import net.n2oapp.framework.api.metadata.meta.fieldset.FieldSet;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class FieldSetColumnCompiler
implements BaseSourceCompiler<FieldSet.Column, N2oFieldsetColumn, CompileContext<?, ?>> {
    public FieldSet.Column compile(N2oFieldsetColumn source, CompileContext<?, ?> context, CompileProcessor p) {
        FieldSet.Column column = new FieldSet.Column();
        column.setClassName(source.getCssClass());
        column.setStyle(StylesResolver.resolveStyles(source.getStyle()));
        column.setSize(source.getSize());
        column.setVisible(ScriptProcessor.resolveExpression((String)source.getVisible()));
        if (source.getItems() != null && source.getItems().length > 0) {
            boolean onlyFields = true;
            for (SourceComponent item : source.getItems()) {
                if (item instanceof N2oField) continue;
                onlyFields = false;
                break;
            }
            if (onlyFields) {
                ArrayList<Field> compiledFields = new ArrayList<Field>();
                for (SourceComponent field : source.getItems()) {
                    compiledFields.add((Field)p.compile((Object)field, context, new Object[0]));
                }
                column.setFields(compiledFields);
            } else {
                ArrayList<FieldSet> fieldSets = new ArrayList<FieldSet>();
                int i = 0;
                while (i < source.getItems().length) {
                    N2oFieldSet fieldSet;
                    if (source.getItems()[i] instanceof N2oFieldSet) {
                        fieldSet = (N2oFieldSet)source.getItems()[i];
                        ++i;
                    } else {
                        N2oSetFieldSet newFieldSet = new N2oSetFieldSet();
                        ArrayList<SourceComponent> fieldSetItems = new ArrayList<SourceComponent>();
                        while (i < source.getItems().length && !(source.getItems()[i] instanceof N2oFieldSet)) {
                            fieldSetItems.add(source.getItems()[i]);
                            ++i;
                        }
                        SourceComponent[] items = new SourceComponent[fieldSetItems.size()];
                        newFieldSet.setItems(fieldSetItems.toArray(items));
                        fieldSet = newFieldSet;
                    }
                    fieldSets.add((FieldSet)p.compile((Object)fieldSet, context, new Object[0]));
                }
                column.setFieldsets(fieldSets);
            }
        }
        return column;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oFieldsetColumn.class;
    }
}

