/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.Breadcrumb;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Filter;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.meta.page.Page;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.BaseMetadataBinder;
import net.n2oapp.framework.config.metadata.compile.redux.Redux;

public abstract class PageBinder<D extends Page>
implements BaseMetadataBinder<D> {
    public D bindPage(D page, BindProcessor p, List<Widget<?>> widgets) {
        if (widgets != null) {
            widgets.forEach(arg_0 -> ((BindProcessor)p).bind(arg_0));
        }
        if (page.getRoutes() != null) {
            HashMap pathMappings = new HashMap();
            page.getRoutes().getPathMapping().forEach((k, v) -> pathMappings.put(k, Redux.createBindLink(v)));
            for (PageRoutes.Route route : page.getRoutes().getList()) {
                route.setPath(p.resolveUrl(route.getPath(), pathMappings, null));
            }
            if (page.getRoutes().getQueryMapping() != null) {
                if (page.getModels() == null) {
                    page.setModels(new Models());
                }
                page.getRoutes().getQueryMapping().keySet().stream().filter(arg_0 -> ((BindProcessor)p).canResolveParam(arg_0)).filter(param -> ((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet() instanceof ModelLink).forEach(param -> {
                    ModelLink modelLink = (ModelLink)((PageRoutes.Query)page.getRoutes().getQueryMapping().get(param)).getOnSet();
                    page.getModels().add(modelLink.getModel(), modelLink.getDatasource(), modelLink.getFieldId(), modelLink);
                });
            }
        }
        if (page.getBreadcrumb() != null) {
            page.setBreadcrumb((List)new BreadcrumbList(page.getBreadcrumb()));
            page.getBreadcrumb().stream().filter(b -> b.getPath() != null).forEach(b -> {
                b.setPath(p.resolveUrl(b.getPath()));
                b.setLabel(p.resolveText(b.getLabel(), b.getModelLink()));
            });
        }
        this.collectFiltersToModels(page.getModels(), widgets, p);
        if (page.getModels() != null) {
            page.getModels().values().forEach(bl -> {
                if (bl.getValue() instanceof String) {
                    bl.setValue((Object)p.resolveText((String)bl.getValue()));
                } else if (bl.getValue() instanceof DefaultValues) {
                    DefaultValues dv = (DefaultValues)bl.getValue();
                    for (String key : dv.getValues().keySet()) {
                        if (!(dv.getValues().get(key) instanceof String)) continue;
                        dv.getValues().put(key, p.resolveText((String)dv.getValues().get(key)));
                    }
                }
            });
            this.resolveLinks(page.getModels(), p);
        }
        if (page.getPageProperty() != null) {
            page.getPageProperty().setTitle(p.resolveText(page.getPageProperty().getTitle(), page.getPageProperty().getModelLink()));
            page.getPageProperty().setHtmlTitle(p.resolveText(page.getPageProperty().getHtmlTitle(), page.getPageProperty().getModelLink()));
            page.getPageProperty().setModalHeaderTitle(p.resolveText(page.getPageProperty().getModalHeaderTitle(), page.getPageProperty().getModelLink()));
        }
        if (page.getBreadcrumb() != null) {
            for (Breadcrumb crumb : page.getBreadcrumb()) {
                crumb.setLabel(p.resolveText(crumb.getLabel(), crumb.getModelLink()));
            }
        }
        return page;
    }

    private void collectFiltersToModels(Models models, List<Widget<?>> widgets, BindProcessor p) {
        if (widgets != null) {
            for (Widget<?> w : widgets) {
                DataSet data;
                if (w.getFilters() == null || w.getFiltersDefaultValuesQueryId() == null || (data = p.executeQuery(w.getFiltersDefaultValuesQueryId())) == null) continue;
                for (Filter filter : w.getFilters()) {
                    this.addDefaultFilterValueLinkToModels(models, w.getId(), filter, data, p);
                }
            }
        }
    }

    private void addDefaultFilterValueLinkToModels(Models models, String widgetId, Filter f, DataSet data, BindProcessor p) {
        Object value = data.get((Object)f.getFilterId());
        if (value != null && !p.canResolveParam(f.getParam())) {
            ModelLink link = new ModelLink(f.getLink());
            link.setValue(value);
            link.setParam(link.getDatasource() + "_" + f.getFilterId());
            f.setLink(link);
            models.add(ReduxModel.FILTER, widgetId, f.getFilterId(), f.getLink());
        }
    }

    private void resolveLinks(Models models, BindProcessor p) {
        new HashSet(models.entrySet()).stream().filter(e -> !((ModelLink)e.getValue()).isConst()).forEach(e -> {
            ModelLink link = (ModelLink)models.get(e.getKey());
            ModelLink resolvedLink = (ModelLink)p.resolveLink((BindLink)link, true);
            models.put((Object)((String)e.getKey()), (Object)resolvedLink);
        });
        new HashSet(models.entrySet()).stream().filter(e -> ((ModelLink)e.getValue()).isConst() && ((ModelLink)e.getValue()).getSubModelLink() != null).forEach(e -> {
            ModelLink link = (ModelLink)models.get(e.getKey());
            ModelLink resolvedSubModelLink = p.resolveSubModels(link);
            models.add(link.getSubModelLink(), resolvedSubModelLink);
        });
    }
}

