/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.n2oapp.framework.api.DynamicUtil;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.SubmitActionType;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oSimplePage;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.page.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.page.SimplePage;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class SimplePageCompiler
extends PageCompiler<N2oSimplePage, SimplePage> {
    private static final String MAIN_WIDGET_ID = "main";

    public SimplePage compile(N2oSimplePage source, PageContext context, CompileProcessor p) {
        SimplePage page = new SimplePage();
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        page.setId((String)p.cast((Object)context.getClientPageId(), (Object)RouteUtil.convertPathToId(pageRoute), new Object[0]));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        String pageName = (String)p.cast((Object)context.getPageName(), (Object)source.getName(), new Object[]{source.getWidget().getName()});
        page.setPageProperty(this.initPageName((N2oPage)source, pageName, context, p));
        page.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        page.setBreadcrumb((List)this.initBreadcrumb(pageName, context, p));
        String refId = source.getWidget().getRefId();
        if (refId != null && !DynamicUtil.isDynamic((String)refId)) {
            source.setWidget((N2oWidget)p.merge((Source)((N2oWidget)p.getSource(refId, N2oWidget.class)), (Source)source.getWidget()));
        }
        N2oWidget widget = source.getWidget();
        widget.setId((String)p.cast((Object)widget.getId(), (Object)MAIN_WIDGET_ID, new Object[0]));
        widget.setRoute((String)p.cast((Object)widget.getRoute(), (Object)("/" + ("/".equals(pageRoute) ? widget.getId() : "")), new Object[0]));
        if (widget.getQueryId() != null) {
            pageScope.setWidgetIdQueryIdMap(Map.of(widget.getId(), widget.getQueryId()));
        }
        pageScope.setWidgetIdDatasourceMap(new HashMap<String, String>());
        pageScope.getWidgetIdDatasourceMap().putAll(Map.of(pageScope.getGlobalWidgetId(widget.getId()), pageScope.getGlobalWidgetId(widget.getDatasource() == null ? widget.getId() : widget.getDatasource())));
        if (context.getParentWidgetIdDatasourceMap() != null) {
            pageScope.getWidgetIdDatasourceMap().putAll(context.getParentWidgetIdDatasourceMap());
        }
        PageRoutes routes = this.initRoute(pageRoute);
        this.initPreFilters(context, widget);
        Models models = new Models();
        page.setModels(models);
        WidgetScope widgetScope = new WidgetScope();
        ParentRouteScope pageRouteScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        BreadcrumbList breadcrumbs = new BreadcrumbList(page.getBreadcrumb());
        ValidationList validationList = new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>());
        if (context.getUpload() != null) {
            widget.setUpload(context.getUpload());
        }
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        Widget compiledWidget = (Widget)p.compile((Object)widget, (CompileContext)context, new Object[]{routes, pageScope, widgetScope, pageRouteScope, breadcrumbs, validationList, models, pageRoutesScope});
        page.setWidget(compiledWidget);
        this.registerRoutes(routes, context, p);
        page.setRoutes(routes);
        this.compileComponent(page, source, context, p);
        String objectId = (String)p.cast((Object)source.getObjectId(), (Object)compiledWidget.getObjectId(), new Object[0]);
        CompiledObject object = null;
        if (objectId != null) {
            object = (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(objectId));
            page.setObject(object);
        }
        if (context.getSubmitOperationId() != null || SubmitActionType.copy.equals((Object)context.getSubmitActionType())) {
            page.setToolbar(this.compileToolbar(context, p, new MetaActions(), pageScope, pageRouteScope, object, breadcrumbs, validationList, widget));
        }
        return page;
    }

    private PageRoutes initRoute(String pageRoute) {
        PageRoutes routes = new PageRoutes();
        routes.addRoute(new PageRoutes.Route(pageRoute));
        return routes;
    }

    private void initPreFilters(PageContext context, N2oWidget widget) {
        if (context.getPreFilters() != null && !context.getPreFilters().isEmpty()) {
            widget.addPreFilters(context.getPreFilters());
        }
    }

    private Toolbar compileToolbar(PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList, N2oWidget widget) {
        N2oToolbar n2oToolbar = new N2oToolbar();
        n2oToolbar.setGenerate(new String[]{GenerateType.submit.name(), GenerateType.close.name()});
        n2oToolbar.setTargetWidgetId((String)p.cast((Object)widget.getId(), (Object)MAIN_WIDGET_ID, new Object[0]));
        ToolbarPlaceScope toolbarPlaceScope = new ToolbarPlaceScope((String)p.resolve(Placeholders.property((String)"n2o.api.page.toolbar.place"), String.class));
        return (Toolbar)p.compile((Object)n2oToolbar, (CompileContext)context, new Object[]{metaActions, pageScope, routeScope, object, new IndexScope(), breadcrumbs, validationList, toolbarPlaceScope});
    }

    public Class<N2oSimplePage> getSourceClass() {
        return N2oSimplePage.class;
    }

    @Override
    protected String getSrcProperty() {
        return "n2o.api.page.simple.src";
    }
}

