/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.Arrays;
import net.n2oapp.criteria.filters.FilterType;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oMongoDbDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class MongodbEngineQueryTransformer
implements SourceTransformer<N2oQuery>,
SourceClassAware {
    public static final String EXPRESSION = "expression";

    public N2oQuery transform(N2oQuery source) {
        if (!this.isMongodb(source)) {
            return source;
        }
        if (source.getFields() != null) {
            for (N2oQuery.Field field : source.getFields()) {
                if (Boolean.FALSE.equals(field.getNoDisplay()) && field.getSelectBody() == null) {
                    this.transformSelect(field);
                }
                if (Boolean.FALSE.equals(field.getNoSorting()) && field.getSortingBody() == null) {
                    this.transformSortings(field);
                }
                if (field.getFilterList() == null) continue;
                this.transformFilters(field);
            }
        }
        return source;
    }

    private void transformSelect(N2oQuery.Field field) {
        if (field.getId().equals("id")) {
            field.setSelectBody("_id");
            field.setSelectMapping("['_id'].toString()");
        } else {
            field.setSelectBody(Placeholders.colon((String)EXPRESSION));
        }
    }

    private void transformSortings(N2oQuery.Field field) {
        if (field.getId().equals("id")) {
            field.setSortingBody("_id :idDirection");
        } else {
            field.setSortingBody(Placeholders.colon((String)EXPRESSION) + " " + Placeholders.colon((String)(field.getId() + "Direction")));
        }
    }

    private void transformFilters(N2oQuery.Field field) {
        block10: for (N2oQuery.Filter filter : field.getFilterList()) {
            String domain = MongodbEngineQueryTransformer.getDomain(filter);
            if (filter.getFilterField() == null) {
                filter.setFilterField(RouteUtil.normalizeParam(field.getId()) + "_" + filter.getType());
            }
            if (filter.getText() != null) continue;
            if (field.getId().equals("id")) {
                if (!filter.getType().equals((Object)FilterType.eq)) continue;
                filter.setText("{ _id: new ObjectId('#" + filter.getFilterField() + "') }");
                continue;
            }
            switch (filter.getType()) {
                case eq: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': " + this.getFilterField(filter, domain) + " }");
                    continue block10;
                }
                case notEq: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$ne: " + this.getFilterField(filter, domain) + " }}");
                    continue block10;
                }
                case like: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$regex: '.*" + Placeholders.hash((String)filter.getFilterField()) + ".*'}}");
                    continue block10;
                }
                case likeStart: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$regex: '" + Placeholders.hash((String)filter.getFilterField()) + ".*'}}");
                    continue block10;
                }
                case more: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$gte: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case less: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$lte: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case in: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$in: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
                case notIn: {
                    filter.setText("{ '" + Placeholders.colon((String)EXPRESSION) + "': {$nin: " + this.getFilterField(filter, domain) + "}}");
                    continue block10;
                }
            }
        }
    }

    private String getFilterField(N2oQuery.Filter filter, String domain) {
        if (domain.equals("string") || domain.equals("date") || domain.equals("localdate") || domain.equals("localdatetime")) {
            return "'" + Placeholders.hash((String)filter.getFilterField()) + "'";
        }
        return Placeholders.hash((String)filter.getFilterField());
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }

    private static String getDomain(N2oQuery.Filter filter) {
        return filter.getDomain() != null ? filter.getDomain().toLowerCase().trim() : "string";
    }

    private boolean isMongodb(N2oQuery source) {
        return this.checkMondodb(source.getLists()) && this.checkMondodb(source.getUniques()) && this.checkMondodb(source.getCounts());
    }

    private boolean checkMondodb(N2oQuery.Selection[] selection) {
        if (selection == null) {
            return true;
        }
        return Arrays.stream(selection).noneMatch(elem -> !(elem.getInvocation() instanceof N2oMongoDbDataProvider));
    }
}

