/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.event.action.N2oAction;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.Confirm;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ConfirmType;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.DisableOnEmptyModelType;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oAbstractButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButtonCondition;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ValidateType;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.action.LinkAction;
import net.n2oapp.framework.api.metadata.meta.action.invoke.InvokeAction;
import net.n2oapp.framework.api.metadata.meta.control.ValidationType;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Condition;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.PerformButton;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.toolbar.BaseButtonCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetObjectScope;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import org.springframework.stereotype.Component;

@Component
public class PerformButtonCompiler
extends BaseButtonCompiler<N2oButton, PerformButton> {
    public Class<? extends Source> getSourceClass() {
        return N2oButton.class;
    }

    public PerformButton compile(N2oButton source, CompileContext<?, ?> context, CompileProcessor p) {
        PerformButton button = new PerformButton();
        IndexScope idx = (IndexScope)p.getScope(IndexScope.class);
        this.initItem((AbstractButton)button, (N2oAbstractButton)source, idx, context, p);
        button.setId((String)p.cast((Object)source.getId(), (Object)source.getActionId(), new Object[]{"menuItem" + idx.get()}));
        source.setId(button.getId());
        button.setSrc((String)p.cast((Object)source.getSrc(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.action.button.src"), String.class)), new Object[0]));
        button.setRounded((Boolean)p.cast((Object)source.getRounded(), (Object)false, new Object[0]));
        if (source.getValidate() != null) {
            button.setValidate(source.getValidate().getValue());
            this.initValidate(source, button, context, p);
        }
        button.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        WidgetObjectScope widgetObjectScope = (WidgetObjectScope)p.getScope(WidgetObjectScope.class);
        if (source.getWidgetId() == null && widgetObjectScope != null && widgetObjectScope.size() == 1) {
            source.setWidgetId((String)widgetObjectScope.keySet().iterator().next());
        }
        Action action = this.compileAction(source, button, context, p);
        button.setAction(action);
        this.initLinkAction(button);
        String objectId = null;
        if (action instanceof InvokeAction) {
            objectId = ((InvokeAction)action).getObjectId();
        }
        CompiledObject compiledObject = this.getCompiledObject(p, objectId, source.getWidgetId());
        button.setConfirm(this.compileConfirm(source, action, context, p, compiledObject));
        if (source.getModel() == null) {
            source.setModel(ReduxModel.RESOLVE);
        }
        this.compileConditionsAndDependencies(source, button, context, p);
        return button;
    }

    private CompiledObject getCompiledObject(CompileProcessor p, String objectId, String widgetId) {
        WidgetObjectScope widgetObjectScope;
        if (objectId != null) {
            return (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(objectId));
        }
        if (widgetId != null && (widgetObjectScope = (WidgetObjectScope)p.getScope(WidgetObjectScope.class)) != null && widgetObjectScope.containsKey(widgetId)) {
            return widgetObjectScope.getObject(widgetId);
        }
        return (CompiledObject)p.getScope(CompiledObject.class);
    }

    private void initLinkAction(PerformButton button) {
        if (button.getAction() instanceof LinkAction) {
            LinkAction linkAction = (LinkAction)button.getAction();
            button.setUrl(linkAction.getUrl());
            button.setTarget(linkAction.getTarget());
            if (linkAction.getPathMapping() != null) {
                button.setPathMapping((Map)new StrictMap(linkAction.getPathMapping()));
            }
            if (linkAction.getQueryMapping() != null) {
                button.setQueryMapping((Map)new StrictMap(linkAction.getQueryMapping()));
            }
        }
    }

    private void initValidate(N2oButton source, PerformButton button, CompileContext<?, ?> context, CompileProcessor p) {
        if (ValidateType.WIDGET.getId().equals(button.getValidate())) {
            button.setValidateWidgetId(this.initWidgetId(source, context, p));
        } else if (ValidateType.PAGE.getId().equals(button.getValidate())) {
            button.setValidatePageId(((PageScope)p.getScope(PageScope.class)).getPageId());
        }
    }

    private Confirm compileConfirm(N2oButton source, Action action, CompileContext<?, ?> context, CompileProcessor p, CompiledObject object) {
        boolean operationConfirm;
        CompiledObject.Operation operation = this.getOperation(action, object);
        boolean bl = operationConfirm = operation != null && operation.getConfirm() != null && operation.getConfirm() != false;
        if (source.getConfirm() != null) {
            Object condition = p.resolveJS(source.getConfirm(), Boolean.class);
            if (condition instanceof Boolean) {
                if (!((Boolean)condition).booleanValue() && !operationConfirm) {
                    return null;
                }
                return this.initConfirm(source, p, context, operation, true);
            }
            if (condition instanceof String) {
                return this.initConfirm(source, p, context, operation, condition);
            }
        }
        if (operationConfirm) {
            return this.initConfirm(source, p, context, operation, true);
        }
        return null;
    }

    private Confirm initConfirm(N2oButton source, CompileProcessor p, CompileContext<?, ?> context, CompiledObject.Operation operation, Object condition) {
        Confirm confirm = new Confirm();
        confirm.setTitle((String)p.cast((Object)source.getConfirmTitle(), (Object)(operation != null ? operation.getFormSubmitLabel() : null), new Object[]{p.getMessage("n2o.confirm.title", new Object[0])}));
        confirm.setMode((ConfirmType)p.cast((Object)source.getConfirmType(), (Object)ConfirmType.modal, new Object[0]));
        confirm.setOkLabel((String)p.cast((Object)source.getConfirmOkLabel(), (Object)p.getMessage("n2o.confirm.default.okLabel", new Object[0]), new Object[0]));
        confirm.setCancelLabel((String)p.cast((Object)source.getConfirmCancelLabel(), (Object)p.getMessage("n2o.confirm.default.cancelLabel", new Object[0]), new Object[0]));
        confirm.setText(this.initExpression((String)p.cast((Object)source.getConfirmText(), (Object)(operation != null ? operation.getConfirmationText() : null), new Object[]{p.getMessage("n2o.confirm.text", new Object[0])})));
        confirm.setCondition(this.initConfirmCondition(condition));
        if (StringUtils.isJs((Object)confirm.getText()) || StringUtils.isJs((Object)confirm.getCondition())) {
            String widgetId = this.initWidgetId(source, context, p);
            String datasource = this.initDatasource(widgetId, p);
            ReduxModel reduxModel = source.getModel();
            confirm.setModelLink(new ModelLink(reduxModel == null ? ReduxModel.RESOLVE : reduxModel, datasource).getBindLink());
        }
        return confirm;
    }

    private String initConfirmCondition(Object condition) {
        if (condition instanceof Boolean) {
            return Placeholders.js((String)Boolean.toString(true));
        }
        return this.initExpression((String)condition);
    }

    private String initExpression(String attr) {
        if (StringUtils.hasLink((String)attr)) {
            Set links = StringUtils.collectLinks((String)attr);
            String text = Placeholders.js((String)("'" + attr + "'"));
            for (String link : links) {
                text = text.replace(Placeholders.ref((String)link), "' + this." + link + " + '");
            }
            return text;
        }
        return attr;
    }

    private CompiledObject.Operation getOperation(Action action, CompiledObject compiledObject) {
        CompiledObject.Operation operation = null;
        if (action != null && action instanceof InvokeAction) {
            operation = compiledObject != null && compiledObject.getOperations() != null && compiledObject.getOperations().containsKey(((InvokeAction)action).getOperationId()) ? (CompiledObject.Operation)compiledObject.getOperations().get(((InvokeAction)action).getOperationId()) : null;
        }
        return operation;
    }

    private Action compileAction(N2oButton source, PerformButton button, CompileContext<?, ?> context, CompileProcessor p) {
        N2oAction butAction = source.getAction();
        if (source.getAction() == null && source.getActionId() != null) {
            MetaActions metaActions = (MetaActions)p.getScope(MetaActions.class);
            N2oAction n2oAction = butAction = metaActions.get(source.getActionId()) == null ? null : ((ActionsBar)metaActions.get(source.getActionId())).getAction();
        }
        if (butAction == null) {
            return null;
        }
        CompiledObject compiledObject = this.getCompiledObject(p, butAction.getObjectId(), source.getWidgetId());
        butAction.setId((String)p.cast((Object)butAction.getId(), (Object)button.getId(), new Object[0]));
        return (Action)p.compile((Object)butAction, context, new Object[]{compiledObject, new ComponentScope(source)});
    }

    private String initWidgetId(N2oButton source, CompileContext<?, ?> context, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (source.getWidgetId() != null) {
            return pageScope == null ? source.getWidgetId() : pageScope.getGlobalWidgetId(source.getWidgetId());
        }
        WidgetScope widgetScope = (WidgetScope)p.getScope(WidgetScope.class);
        if (widgetScope != null) {
            return widgetScope.getClientWidgetId();
        }
        if (context instanceof PageContext && ((PageContext)context).getResultWidgetId() != null) {
            return pageScope.getGlobalWidgetId(((PageContext)context).getResultWidgetId());
        }
        throw new N2oException("Unknown widgetId for invoke action!");
    }

    private String initDatasource(String widgetId, CompileProcessor p) {
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        return pageScope == null || pageScope.getWidgetIdDatasourceMap() == null ? widgetId : pageScope.getWidgetIdDatasourceMap().get(widgetId);
    }

    protected void compileConditionsAndDependencies(N2oButton source, PerformButton button, CompileContext<?, ?> context, CompileProcessor p) {
        ComponentScope componentScope;
        Condition emptyModelCondition;
        String widgetId = this.initWidgetId(source, context, p);
        String datasource = this.initDatasource(widgetId, p);
        ArrayList<Condition> enabledConditions = new ArrayList<Condition>();
        if (source.getVisibilityConditions() != null) {
            button.getConditions().put(ValidationType.visible, this.compileConditions(source.getVisibilityConditions(), source.getModel(), datasource));
        }
        if (source.getEnablingConditions() != null) {
            enabledConditions.addAll(this.compileConditions(source.getEnablingConditions(), source.getModel(), datasource));
        }
        if ((emptyModelCondition = this.enabledByEmptyModelCondition(source, datasource, componentScope = (ComponentScope)p.getScope(ComponentScope.class), p)) != null) {
            enabledConditions.add(emptyModelCondition);
        }
        if (!enabledConditions.isEmpty()) {
            button.getConditions().put(ValidationType.enabled, enabledConditions);
        }
        if (source.getDependencies() != null) {
            this.compileDependencies(source.getDependencies(), button, widgetId, source.getModel(), p);
        }
        if (componentScope != null && componentScope.unwrap(N2oCell.class) != null) {
            button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
            button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
        } else {
            if (StringUtils.isLink((Object)source.getVisible())) {
                this.compileLinkCondition(button, datasource, ValidationType.visible, source.getVisible(), source.getModel());
            } else {
                button.setVisible(p.resolveJS(source.getVisible(), Boolean.class));
            }
            if (StringUtils.isLink((Object)source.getEnabled())) {
                this.compileLinkCondition(button, datasource, ValidationType.enabled, source.getEnabled(), source.getModel());
            } else {
                button.setEnabled(p.resolveJS(source.getEnabled(), Boolean.class));
            }
        }
    }

    private Condition enabledByEmptyModelCondition(N2oButton source, String datasource, ComponentScope componentScope, CompileProcessor p) {
        boolean autoDisableCondition;
        DisableOnEmptyModelType disableOnEmptyModel = (DisableOnEmptyModelType)p.cast((Object)source.getDisableOnEmptyModel(), (Object)((DisableOnEmptyModelType)p.resolve(Placeholders.property((String)"n2o.api.button.disable_on_empty_model"), DisableOnEmptyModelType.class)), new Object[0]);
        if (DisableOnEmptyModelType.FALSE.equals((Object)disableOnEmptyModel)) {
            return null;
        }
        boolean parentIsNotCell = componentScope == null || componentScope.unwrap(N2oCell.class) == null;
        boolean bl = autoDisableCondition = DisableOnEmptyModelType.AUTO.equals((Object)disableOnEmptyModel) && (ReduxModel.RESOLVE.equals((Object)source.getModel()) || ReduxModel.MULTI.equals((Object)source.getModel())) && parentIsNotCell;
        if (DisableOnEmptyModelType.TRUE.equals((Object)disableOnEmptyModel) || autoDisableCondition) {
            Condition condition = new Condition();
            condition.setExpression("!_.isEmpty(this)");
            condition.setModelLink(new ModelLink(source.getModel(), datasource).getBindLink());
            return condition;
        }
        return null;
    }

    private List<Condition> compileConditions(N2oButtonCondition[] conditions, ReduxModel model, String datasource) {
        ArrayList<Condition> result = new ArrayList<Condition>();
        for (N2oButtonCondition n2oCondition : conditions) {
            Condition condition = new Condition();
            condition.setExpression(n2oCondition.getExpression().trim());
            condition.setModelLink(new ModelLink(model, datasource).getBindLink());
            result.add(condition);
        }
        return result;
    }

    private void compileLinkCondition(PerformButton button, String datasource, ValidationType type, String linkCondition, ReduxModel model) {
        Condition condition = new Condition();
        condition.setExpression(StringUtils.unwrapLink((String)linkCondition));
        condition.setModelLink(new ModelLink(model, datasource).getBindLink());
        if (!button.getConditions().containsKey(type)) {
            button.getConditions().put(type, new ArrayList());
        }
        ((List)button.getConditions().get(type)).add(condition);
    }

    private void compileDependencies(N2oButton.Dependency[] dependencies, PerformButton button, String widgetId, ReduxModel buttonModel, CompileProcessor p) {
        for (N2oButton.Dependency d : dependencies) {
            ValidationType validationType = null;
            if (d instanceof N2oButton.EnablingDependency) {
                validationType = ValidationType.enabled;
            } else if (d instanceof N2oButton.VisibilityDependency) {
                validationType = ValidationType.visible;
            }
            this.compileCondition(d, button, validationType, widgetId, buttonModel, p);
        }
    }

    private void compileCondition(N2oButton.Dependency dependency, PerformButton button, ValidationType validationType, String widgetId, ReduxModel buttonModel, CompileProcessor p) {
        String datasource = widgetId;
        PageScope pageScope = (PageScope)p.getScope(PageScope.class);
        if (pageScope != null && pageScope.getWidgetIdDatasourceMap() != null) {
            datasource = dependency.getRefWidgetId() != null ? pageScope.getWidgetIdDatasourceMap().get(pageScope.getGlobalWidgetId(dependency.getRefWidgetId())) : pageScope.getWidgetIdDatasourceMap().get(widgetId);
        }
        ReduxModel refModel = (ReduxModel)p.cast((Object)dependency.getRefModel(), (Object)buttonModel, new Object[]{ReduxModel.RESOLVE});
        Condition condition = new Condition();
        condition.setExpression(ScriptProcessor.resolveFunction((String)dependency.getValue()));
        condition.setModelLink(new ModelLink(refModel, datasource, null).getBindLink());
        if (dependency instanceof N2oButton.EnablingDependency) {
            condition.setMessage(((N2oButton.EnablingDependency)dependency).getMessage());
        }
        if (!button.getConditions().containsKey(validationType)) {
            button.getConditions().put(validationType, new ArrayList());
        }
        ((List)button.getConditions().get(validationType)).add(condition);
    }
}

