/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.toolbar;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.MetadataEnvironmentAware;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.ButtonGeneratorFactory;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.AbstractButton;
import net.n2oapp.framework.api.metadata.meta.widget.toolbar.Group;
import net.n2oapp.framework.config.metadata.compile.BaseSourceCompiler;
import net.n2oapp.framework.config.metadata.compile.toolbar.ToolbarPlaceScope;
import org.springframework.stereotype.Component;

@Component
public class ToolbarCompiler
implements BaseSourceCompiler<Toolbar, N2oToolbar, CompileContext<?, ?>>,
SourceClassAware,
MetadataEnvironmentAware {
    protected ButtonGeneratorFactory buttonGeneratorFactory;

    public Toolbar compile(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p) {
        Toolbar toolbar = new Toolbar();
        this.initGenerate(source, context, p);
        if (source.getItems() == null) {
            return toolbar;
        }
        ToolbarPlaceScope toolbarPlaceScope = (ToolbarPlaceScope)p.getScope(ToolbarPlaceScope.class);
        String defaultPlace = toolbarPlaceScope != null ? toolbarPlaceScope.getPlace() : (String)p.resolve(Placeholders.property((String)"n2o.api.widget.toolbar.place"), String.class);
        String place = (String)p.cast((Object)source.getPlace(), (Object)defaultPlace, new Object[0]);
        ArrayList<Group> groups = new ArrayList<Group>();
        this.initGroups(source, context, p, groups, place);
        toolbar.put((Object)place, groups);
        return toolbar;
    }

    private void initGroups(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p, List<Group> groups, String place) {
        int gi = 0;
        int i = 0;
        Boolean buttonGrouping = this.isGrouping(p);
        while (i < source.getItems().length) {
            Group gr = new Group(place + gi++);
            ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
            ToolbarItem item = source.getItems()[i];
            if (item instanceof N2oGroup) {
                N2oGroup group = (N2oGroup)item;
                if (group.getGenerate() != null) {
                    for (String string : group.getGenerate()) {
                        this.buttonGeneratorFactory.generate(string.trim(), source, context, p).forEach(j -> buttons.add(this.getButton(source, (ToolbarItem)j, context, p)));
                    }
                } else {
                    for (String string : group.getItems()) {
                        buttons.add(this.getButton(source, (ToolbarItem)string, context, p));
                    }
                }
                ++i;
            } else {
                while (i < source.getItems().length && !(source.getItems()[i] instanceof N2oGroup)) {
                    buttons.add(this.getButton(source, source.getItems()[i], context, p));
                    ++i;
                    if (buttonGrouping.booleanValue()) continue;
                }
            }
            gr.setButtons(buttons);
            groups.add(gr);
        }
    }

    protected void initGenerate(N2oToolbar source, CompileContext<?, ?> context, CompileProcessor p) {
        if (source.getGenerate() != null) {
            for (String generate : source.getGenerate()) {
                this.buttonGeneratorFactory.generate(generate.trim(), source, context, p).forEach(i -> source.setItems(this.push(source, (N2oButton)i)));
            }
        }
    }

    private AbstractButton getButton(N2oToolbar source, ToolbarItem item, CompileContext<?, ?> context, CompileProcessor p) {
        return (AbstractButton)p.compile((Object)item, context, new Object[]{source});
    }

    private ToolbarItem[] push(N2oToolbar source, N2oButton button) {
        ToolbarItem[] items;
        if (source.getItems() == null) {
            items = new ToolbarItem[]{button};
        } else {
            int length = source.getItems().length;
            items = new ToolbarItem[length + 1];
            System.arraycopy(source.getItems(), 0, items, 0, length);
            items[length] = button;
        }
        return items;
    }

    private Boolean isGrouping(CompileProcessor p) {
        Object buttonGrouping = p.resolve(Placeholders.property((String)"n2o.api.toolbar.grouping"));
        return buttonGrouping instanceof Boolean ? (Boolean)buttonGrouping : true;
    }

    public void setEnvironment(MetadataEnvironment environment) {
        this.buttonGeneratorFactory = environment.getButtonGeneratorFactory();
    }

    public Class<? extends Source> getSourceClass() {
        return N2oToolbar.class;
    }
}

