/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.widget;

import java.util.ArrayList;
import java.util.List;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oAbstractListWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oCards;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oCell;
import net.n2oapp.framework.api.metadata.global.view.widget.table.column.cell.N2oTextCell;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.meta.widget.Cards;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.widget.BaseListWidgetCompiler;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.util.StylesResolver;
import org.springframework.stereotype.Component;

@Component
public class CardsCompiler
extends BaseListWidgetCompiler<Cards, N2oCards> {
    @Override
    protected String getPropertyWidgetSrc() {
        return "n2o.api.widget.cards.src";
    }

    public Class<? extends Source> getSourceClass() {
        return N2oCards.class;
    }

    public Cards compile(N2oCards source, CompileContext<?, ?> context, CompileProcessor p) {
        Cards cards = new Cards();
        CompiledObject object = this.getObject(source, p);
        this.compileWidget(cards, source, context, p, object);
        ParentRouteScope widgetRoute = this.initWidgetRouteScope(cards, context, p);
        PageRoutesScope pageRoutesScope = (PageRoutesScope)p.getScope(PageRoutesScope.class);
        if (pageRoutesScope != null) {
            pageRoutesScope.put(cards.getId(), widgetRoute);
        }
        this.compileDataProviderAndRoutes(cards, source, context, p, null, widgetRoute, null, null, object);
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setWidgetId(source.getId());
        widgetScope.setQueryId(source.getQueryId());
        widgetScope.setClientWidgetId(cards.getId());
        MetaActions widgetActions = this.initMetaActions(source);
        this.compileToolbarAndAction(cards, source, context, p, widgetScope, widgetRoute, widgetActions, object, null);
        if (source.getContent() != null) {
            cards.setCards(this.compileCols(source.getContent(), context, p, object, widgetScope, widgetActions));
        }
        cards.setVerticalAlign((Cards.Position)p.cast((Object)source.getVerticalAlign(), (Object)((Cards.Position)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.vertical_align"), Cards.Position.class)), new Object[0]));
        cards.setHeight((String)p.cast((Object)source.getHeight(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.height"), String.class)), new Object[0]));
        cards.setPaging(this.compilePaging((Widget)cards, (N2oAbstractListWidget)source, (Integer)p.resolve(Placeholders.property((String)"n2o.api.widget.cards.size"), Integer.class), p));
        return cards;
    }

    private List<Cards.Card> compileCols(N2oCards.Col[] source, CompileContext<?, ?> context, CompileProcessor p, CompiledObject object, WidgetScope widgetScope, MetaActions widgetActions) {
        ArrayList<Cards.Card> cards = new ArrayList<Cards.Card>(source.length);
        for (N2oCards.Col col : source) {
            Cards.Card card = new Cards.Card();
            card.setSize(col.getSize());
            if (col.getBlocks() != null) {
                card.setContent(this.compileBlock(col.getBlocks(), context, p, object, widgetScope, widgetActions));
            }
            cards.add(card);
        }
        return cards;
    }

    private List<Cards.Block> compileBlock(N2oCards.Block[] source, CompileContext<?, ?> context, CompileProcessor p, Object ... scopes) {
        ArrayList<Cards.Block> blocks = new ArrayList<Cards.Block>(source.length);
        for (N2oCards.Block block : source) {
            Cards.Block clientBlock = new Cards.Block();
            block.setId((String)p.cast((Object)block.getId(), (Object)block.getTextFieldId(), new Object[0]));
            clientBlock.setId(block.getId());
            clientBlock.setClassName(block.getCssClass());
            clientBlock.setStyle(StylesResolver.resolveStyles(block.getStyle()));
            N2oCell cell = block.getComponent();
            if (cell == null) {
                cell = new N2oTextCell();
            }
            clientBlock.setComponent((N2oCell)p.compile((Object)cell, context, new Object[]{p, new IndexScope(), new ComponentScope(block), scopes}));
            blocks.add(clientBlock);
        }
        return blocks;
    }
}

