/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.control;

import java.util.HashSet;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.control.N2oField;
import net.n2oapp.framework.api.metadata.control.N2oListField;
import net.n2oapp.framework.api.metadata.control.interval.N2oSimpleIntervalField;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.validation.standard.widget.FieldsScope;
import org.springframework.stereotype.Component;

@Component
public class FieldValidator
implements SourceValidator<N2oField>,
SourceClassAware {
    public void validate(N2oField source, ValidateProcessor p) {
        if (p.getScope(FieldsScope.class) != null) {
            FieldsScope scope = (FieldsScope)p.getScope(FieldsScope.class);
            Boolean sameFieldIdHasDependency = (Boolean)scope.get(source.getId());
            if (sameFieldIdHasDependency != null && (sameFieldIdHasDependency.booleanValue() || source.getDependencies() != null)) {
                throw new N2oMetadataValidationException(String.format("\u041f\u043e\u043b\u0435 %s \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u0440\u0430\u0437\u0430", source.getId()));
            }
            scope.put(source.getId(), source.getDependencies() != null);
        }
        this.checkDefaultValues(source);
        this.checkDependencies(source);
    }

    private void checkDefaultValues(N2oField source) {
        if ((source.getRefPage() != null || source.getRefWidgetId() != null || source.getRefModel() != null) && source.getRefFieldId() == null) {
            if (source instanceof N2oListField) {
                N2oListField list = (N2oListField)source;
                this.checkListFieldDefaultValues(list);
            } else if (source instanceof N2oSimpleIntervalField) {
                N2oSimpleIntervalField interval = (N2oSimpleIntervalField)source;
                if (interval.getBegin() == null && interval.getEnd() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u0437\u0430\u0434\u0430\u043d", source.getId()));
                }
                if (!StringUtils.isLink((Object)interval.getBegin()) && !StringUtils.isLink((Object)interval.getEnd())) {
                    throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439", source.getId()));
                }
            } else if (!StringUtils.isLink((Object)source.getDefaultValue())) {
                throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s \u0430\u0442\u0440\u0438\u0431\u0443\u0442 default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439 \u0438\u043b\u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d: %s", source.getId(), source.getDefaultValue()));
            }
        }
    }

    private void checkListFieldDefaultValues(N2oListField list) {
        if (list.getDefValue() == null) {
            throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u0437\u0430\u0434\u0430\u043d", list.getId()));
        }
        if (list.getDefValue().values().stream().filter(StringUtils::isLink).findFirst().isEmpty()) {
            throw new N2oMetadataValidationException(String.format("\u0423 \u043f\u043e\u043b\u044f %s default-value \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439", list.getId()));
        }
    }

    private void checkDependencies(N2oField source) {
        if (source.getDependencies() != null) {
            HashSet dependencyClasses = new HashSet();
            for (N2oField.Dependency dependency : source.getDependencies()) {
                if (N2oField.SetValueDependency.class.equals(dependency.getClass()) || dependencyClasses.add(dependency.getClass())) continue;
                throw new N2oMetadataValidationException(String.format("\u0412 \u043f\u043e\u043b\u0435 %s \u043f\u043e\u0432\u0442\u043e\u0440\u044f\u044e\u0442\u0441\u044f \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430", source.getId()));
            }
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oField.class;
    }
}

