/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.page;

import java.util.Collection;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.N2oMetadata;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import org.springframework.stereotype.Component;

@Component
public class PageValidator
implements SourceValidator<N2oPage>,
SourceClassAware {
    public Class<? extends Source> getSourceClass() {
        return N2oPage.class;
    }

    public void validate(N2oPage page, ValidateProcessor p) {
        if (page.getObjectId() != null) {
            this.checkForExistsObject(page.getId(), page.getObjectId(), p);
        }
        PageScope scope = new PageScope();
        scope.setWidgetIds(p.safeStreamOf((Collection)page.getWidgets()).map(N2oMetadata::getId).collect(Collectors.toSet()));
        p.safeStreamOf((Collection)page.getWidgets()).forEach(widget -> p.validate((Source)widget, new Object[]{scope}));
        this.checkForExistsDependsOnWidget(page, scope, p);
    }

    private void checkForExistsObject(String pageId, String objectId, ValidateProcessor p) {
        p.checkForExists(objectId, N2oObject.class, String.format("\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 %s \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 %s", pageId, objectId));
    }

    private void checkForExistsDependsOnWidget(N2oPage page, PageScope scope, ValidateProcessor p) {
        p.safeStreamOf((Collection)page.getWidgets()).filter(w -> w.getDependsOn() != null).forEach(w -> {
            if (!scope.getWidgetIds().contains(w.getDependsOn())) {
                throw new N2oMetadataValidationException("\u0410\u0442\u0440\u0438\u0431\u0443\u0442 depends-on \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u0432\u0438\u0434\u0436\u0435\u0442 " + w.getDependsOn());
            }
        });
    }
}

