/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.validation.standard.widget;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.global.dao.N2oPreFilter;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.api.metadata.global.dao.object.N2oObject;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.validate.SourceValidator;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import org.springframework.stereotype.Component;

@Component
public class WidgetValidator
implements SourceValidator<N2oWidget>,
SourceClassAware {
    public void validate(N2oWidget n2oWidget, ValidateProcessor p) {
        N2oQuery query = this.checkQueryExists(n2oWidget, p);
        this.checkObjectExists(n2oWidget, p);
        if (n2oWidget.getToolbars() != null) {
            ArrayList<N2oButton> menuItems = new ArrayList<N2oButton>();
            for (N2oToolbar toolbar : n2oWidget.getToolbars()) {
                if (toolbar.getItems() == null) continue;
                for (ToolbarItem item : toolbar.getItems()) {
                    if (item instanceof N2oButton) {
                        menuItems.add((N2oButton)item);
                        continue;
                    }
                    if (!(item instanceof N2oSubmenu)) continue;
                    menuItems.addAll(Arrays.asList(((N2oSubmenu)item).getMenuItems()));
                }
            }
            p.safeStreamOf(menuItems).forEach(menuItem -> p.validate((Source)menuItem.getAction(), new Object[0]));
            p.checkIdsUnique(menuItems, "\u041a\u043d\u043e\u043f\u043a\u0430 '{0}' \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f \u0431\u043e\u043b\u0435\u0435 \u0447\u0435\u043c \u043e\u0434\u0438\u043d \u0440\u0430\u0437 \u0432 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '" + n2oWidget.getId() + "'!");
        }
        this.checkPrefiltersValidation(n2oWidget, query);
        p.safeStreamOf((Object[])n2oWidget.getActions()).forEach(actionsBar -> p.validate((Source)actionsBar.getAction(), new Object[0]));
        this.checkDatasourceValue(n2oWidget, p);
    }

    private void checkPrefiltersValidation(N2oWidget n2oWidget, N2oQuery query) {
        if (n2oWidget.getPreFilters() != null) {
            if (query == null) {
                throw new N2oMetadataValidationException(String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430 \u0432\u044b\u0431\u043e\u0440\u043a\u0430", n2oWidget.getId()));
            }
            if (query.getFields() == null) {
                throw new N2oMetadataValidationException(String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0438\u043c\u0435\u0435\u0442 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u044b, \u043d\u043e \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '%s' \u043d\u0435\u0442 fields!", n2oWidget.getId(), query.getId()));
            }
            for (N2oPreFilter preFilter : n2oWidget.getPreFilters()) {
                if (preFilter.getValue() != null && preFilter.getParam() != null && !Boolean.TRUE.equals(preFilter.getRoutable())) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0435 \u043f\u043e \u043f\u043e\u043b\u044e '%s' \u0443\u043a\u0430\u0437\u0430\u043d value \u0438 param, \u043d\u043e \u043f\u0440\u0438 \u044d\u0442\u043e\u043c routable=false, \u0447\u0442\u043e \u043f\u0440\u043e\u0442\u0438\u0432\u043e\u0440\u0435\u0447\u0438\u0442 \u043b\u043e\u0433\u0438\u043a\u0435 \u0440\u0430\u0431\u043e\u0442\u044b \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432!", preFilter.getFieldId() == null ? "" : preFilter.getFieldId()));
                }
                N2oQuery.Field exField = null;
                for (N2oQuery.Field field : query.getFields()) {
                    if (!preFilter.getFieldId().equals(field.getId())) continue;
                    exField = field;
                    break;
                }
                if (exField == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '%s' \u043d\u0435\u0442 field '%s'!", query.getId() == null ? "" : query.getId(), preFilter.getFieldId()));
                }
                if (exField.getFilterList() == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '%s' field '%s' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440\u043e\u0432!", query.getId() == null ? "" : query.getId(), preFilter.getFieldId()));
                }
                N2oQuery.Filter exFilter = null;
                for (N2oQuery.Filter filter : exField.getFilterList()) {
                    if (preFilter.getType() != filter.getType()) continue;
                    exFilter = filter;
                    break;
                }
                if (exFilter == null) {
                    throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u044b\u0431\u043e\u0440\u043a\u0435 '%s' field '%s' \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0444\u0438\u043b\u044c\u0442\u0440 \u0442\u0438\u043f\u0430 '%s'!", query.getId() == null ? "" : query.getId(), preFilter.getFieldId(), preFilter.getType()));
                }
                if (n2oWidget.getDependsOn() != null || n2oWidget.getDetailFieldId() != null || preFilter.getRefWidgetId() != null || !StringUtils.hasLink((String)preFilter.getValue())) continue;
                throw new N2oMetadataValidationException(String.format("\u0412 \u0432\u0438\u0434\u0436\u0435\u0442\u0435 '%s' \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0440\u0435\u0444\u0438\u043b\u044c\u0442\u0440\u0430 '%s' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0441\u044b\u043b\u043a\u043e\u0439, \u043d\u043e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u043e\u0441\u0442\u044c \u0434\u043b\u044f \u043d\u0435\u0435 \u043d\u0435 \u043f\u0440\u043e\u043f\u0438\u0441\u0430\u043d\u0430!", n2oWidget.getId() == null ? "" : n2oWidget.getId(), preFilter.getFieldId()));
            }
        }
    }

    private N2oQuery checkQueryExists(N2oWidget n2oWidget, ValidateProcessor p) {
        if (n2oWidget.getQueryId() != null) {
            p.checkForExists(n2oWidget.getQueryId(), N2oQuery.class, String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 '%s'", n2oWidget.getId(), n2oWidget.getQueryId()));
            return (N2oQuery)p.getOrThrow(n2oWidget.getQueryId(), N2oQuery.class);
        }
        if (n2oWidget.getDefaultValuesQueryId() != null) {
            p.checkForExists(n2oWidget.getDefaultValuesQueryId(), N2oQuery.class, String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u043e\u0440\u043a\u0443 '%s'", n2oWidget.getId(), n2oWidget.getDefaultValuesQueryId()));
            return (N2oQuery)p.getOrThrow(n2oWidget.getDefaultValuesQueryId(), N2oQuery.class);
        }
        return null;
    }

    private void checkObjectExists(N2oWidget n2oWidget, ValidateProcessor p) {
        if (n2oWidget.getObjectId() != null) {
            p.checkForExists(n2oWidget.getObjectId(), N2oObject.class, String.format("\u0412\u0438\u0434\u0436\u0435\u0442 '%s' \u0441\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u043d\u0435\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0439 \u043e\u0431\u044a\u0435\u043a\u0442 '%s'", n2oWidget.getId(), n2oWidget.getObjectId()));
        }
    }

    private void checkDatasourceValue(N2oWidget n2oWidget, ValidateProcessor p) {
        if (n2oWidget.getDatasource() != null) {
            PageScope pageScope = (PageScope)p.getScope(PageScope.class);
            if (pageScope.getDatasourceValueMap().containsKey(n2oWidget.getDatasource())) {
                PageScope.DatasourceValue actual = pageScope.getDatasourceValueMap().get(n2oWidget.getDatasource());
                if (!Objects.equals(actual.getQueryId(), n2oWidget.getQueryId())) {
                    throw new N2oMetadataValidationException(String.format("2 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 \u0441 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u043c datasource %s \u0438\u043c\u0435\u044e\u0442 \u0440\u0430\u0437\u043d\u044b\u0435 query-id", n2oWidget.getDatasource()));
                }
                if (!Objects.equals(actual.getObjectId(), n2oWidget.getObjectId())) {
                    throw new N2oMetadataValidationException(String.format("2 \u0432\u0438\u0434\u0436\u0435\u0442\u0430 \u0441 \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u043c datasource %s \u0438\u043c\u0435\u044e\u0442 \u0440\u0430\u0437\u043d\u044b\u0435 object-id", n2oWidget.getDatasource()));
                }
            } else {
                pageScope.getDatasourceValueMap().put(n2oWidget.getDatasource(), new PageScope.DatasourceValue(n2oWidget.getQueryId(), n2oWidget.getObjectId()));
            }
        }
    }

    public Class<? extends Source> getSourceClass() {
        return N2oWidget.class;
    }
}

