/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.route;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import net.n2oapp.framework.api.event.MetadataChangedEvent;
import net.n2oapp.framework.api.event.N2oEventListener;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.register.route.RouteInfoKey;
import net.n2oapp.framework.api.register.route.RouteRegister;
import net.n2oapp.framework.config.register.ConfigRepository;
import net.n2oapp.framework.config.register.route.IncorrectRouteException;
import net.n2oapp.framework.config.register.route.RouteAlreadyExistsException;
import net.n2oapp.framework.config.register.route.StubRouteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class N2oRouteRegister
implements RouteRegister,
N2oEventListener<MetadataChangedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(N2oRouteRegister.class);
    private final SortedMap<RouteInfoKey, CompileContext> register = new ConcurrentSkipListMap<RouteInfoKey, CompileContext>();
    private final ConfigRepository<RouteInfoKey, CompileContext> repository;

    public N2oRouteRegister() {
        this.repository = new StubRouteRepository();
    }

    public N2oRouteRegister(ConfigRepository<RouteInfoKey, CompileContext> repository) {
        this.repository = repository;
    }

    public void addRoute(String urlPattern, CompileContext<? extends Compiled, ?> context) {
        RouteInfoKey key;
        if (this.register.isEmpty()) {
            this.synchronize();
        }
        if (!(key = new RouteInfoKey(urlPattern, context.getCompiledClass())).getUrlMatching().startsWith("/")) {
            throw new IncorrectRouteException(key.getUrlMatching());
        }
        CompileContext registeredContext = (CompileContext)this.register.get(key);
        if (registeredContext == null) {
            this.register.put(key, context);
            this.repository.save(key, context);
        } else if (!registeredContext.equals(context)) {
            throw new RouteAlreadyExistsException(urlPattern, context.getCompiledClass());
        }
        logger.info(String.format("Register route: '%s' to [%s]", context, urlPattern));
    }

    public Iterator<Map.Entry<RouteInfoKey, CompileContext>> iterator() {
        return this.register.entrySet().iterator();
    }

    public void clearAll() {
        this.register.clear();
        this.repository.clearAll();
    }

    public boolean synchronize() {
        Map<RouteInfoKey, CompileContext> stored = this.repository.getAll();
        for (Map.Entry<RouteInfoKey, CompileContext> entry : this.register.entrySet()) {
            if (stored.containsKey(entry.getKey())) continue;
            this.repository.save(entry.getKey(), entry.getValue());
        }
        boolean result = false;
        for (Map.Entry<RouteInfoKey, CompileContext> entry : stored.entrySet()) {
            this.register.put(entry.getKey(), entry.getValue());
            if (this.register.containsKey(entry.getKey())) continue;
            result = true;
            logger.info(String.format("Register route from repository: '%s' to [%s]", entry.getValue(), entry.getKey().getUrlMatching()));
        }
        return result;
    }

    public void handleEvent(MetadataChangedEvent event) {
        this.clearAll();
    }
}

