/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.register.route;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.config.register.route.IncorrectRouteException;

public abstract class RouteUtil {
    public static String parent(String route) {
        return route.startsWith("/") ? ".." + route : "../" + route;
    }

    public static String normalize(String url) {
        url = (url = url.replaceAll("[/]+", "/")).endsWith("/") ? url.substring(0, url.length() - 1) : url;
        url = !url.startsWith("/") && !url.startsWith("../") ? "/" + url : url;
        return url;
    }

    public static String normalizeParam(String field) {
        return field.replaceAll("\\W", "_").replaceAll("_{1,}", "_");
    }

    public static String addQueryParams(String route, Map<String, ModelLink> queryMapping) {
        if (queryMapping == null || queryMapping.isEmpty()) {
            return route;
        }
        StringBuilder params = new StringBuilder();
        queryMapping.keySet().stream().forEach(k -> {
            ModelLink link = (ModelLink)queryMapping.get(k);
            params.append(params.length() > 0 ? "&" : "").append(link.getParam() == null ? k : link.getParam()).append("=").append(link.isConst() ? link.getValue() : ":" + k);
        });
        if (params.length() == 0) {
            return route;
        }
        if (route.contains("?")) {
            return String.format("%s&%s", route, params.toString());
        }
        return String.format("%s?%s", route, params.toString());
    }

    public static List<String> getParams(String url) {
        ArrayList<String> result = new ArrayList<String>();
        String[] urlParts = url.split("\\?");
        String[] splitUrl = urlParts[0].split("/");
        for (int i = 0; i < splitUrl.length && i < splitUrl.length; ++i) {
            String token = splitUrl[i];
            if (!token.startsWith(":")) continue;
            result.add(token.substring(1));
        }
        if (urlParts.length == 2) {
            String[] splitParam = urlParts[1].split("&");
            for (int i = 0; i < splitParam.length && i < splitParam.length; ++i) {
                if (!splitParam[i].contains(":")) continue;
                result.add(splitParam[i].substring(splitParam[i].indexOf(":") + 1));
            }
        }
        return result;
    }

    public static List<String> getPathParams(String url) {
        ArrayList<String> pathParams = new ArrayList<String>();
        String[] urlParts = url.split("\\?");
        Matcher matcher = Pattern.compile("(:\\w+)").matcher(urlParts[0]);
        while (matcher.find()) {
            pathParams.add(matcher.group().substring(1));
        }
        return pathParams;
    }

    public static Map<String, String> parseQueryParams(String url) {
        if (url == null || !url.contains("=") && !url.contains("&")) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        String[] splitParam = url.split("&");
        for (int i = 0; i < splitParam.length && i < splitParam.length; ++i) {
            String[] paramValue = splitParam[i].split("=");
            result.put(paramValue[0], paramValue[1]);
        }
        return result;
    }

    public static String convertPathToId(String url) {
        if (url == null) {
            return null;
        }
        if ((url = RouteUtil.normalize(url)).startsWith("/")) {
            url = url.substring(1);
        }
        if (url.isEmpty()) {
            return "_";
        }
        return url.replaceAll("/:\\w+/", "/").replaceAll("/:\\w+$", "").replace("/", "_").replace(":", "");
    }

    public static String resolveUrlParams(String url, Map<String, Object> data) {
        return RouteUtil.resolveUrlParams(url, data, null, null);
    }

    public static String resolveParams(String url, Map<String, Object> data, Set<String> except) {
        HashSet<String> pathParams = new HashSet<String>(RouteUtil.getParams(url));
        if (except != null) {
            pathParams.removeAll(except);
        }
        for (String param : pathParams) {
            Object value = data.get(param);
            if (value == null) continue;
            url = url.replace(":" + param, value.toString());
        }
        return url;
    }

    public static String resolveUrlParams(String url, Map<String, Object> data, Set<String> whiteList, Set<String> blackList) {
        if (data == null) {
            return url;
        }
        Set<String> pathParams = new HashSet<String>(RouteUtil.getParams(url));
        if (whiteList != null) {
            pathParams = pathParams.stream().filter(s -> whiteList.contains(s)).collect(Collectors.toSet());
        }
        if (blackList != null) {
            pathParams.removeAll(blackList);
        }
        for (String param : pathParams) {
            Object value = data.get(param);
            if (value == null) continue;
            url = url.replace(":" + param, value.toString());
        }
        return url;
    }

    public static boolean isApplicationUrl(String url) {
        return !url.startsWith("http") && !url.startsWith("//");
    }

    public static String absolute(String relativeRoute, String baseRoute) {
        if (!RouteUtil.isApplicationUrl(relativeRoute)) {
            return relativeRoute;
        }
        if (relativeRoute.startsWith("/")) {
            return relativeRoute;
        }
        return RouteUtil.join(baseRoute, relativeRoute);
    }

    public static String join(String parentRoute, String childRoute) {
        if (!RouteUtil.isApplicationUrl(childRoute)) {
            return childRoute;
        }
        if (parentRoute == null) {
            return RouteUtil.normalize(childRoute);
        }
        int k = 0;
        Object child = childRoute;
        while (((String)child).startsWith("../")) {
            child = ((String)child).substring(((String)child).indexOf("../") + 3);
            ++k;
        }
        child = "/" + (String)child;
        StringBuilder result = new StringBuilder();
        if (k > 0) {
            String[] parent = parentRoute.split("/");
            if (parent.length <= k) {
                throw new IncorrectRouteException(childRoute);
            }
            for (int i = 0; i < parent.length - k; ++i) {
                result.append("/").append(parent[i]);
            }
            result.append((String)child);
        } else {
            result.append(parentRoute).append(RouteUtil.normalize(childRoute));
        }
        return RouteUtil.normalize(result.toString());
    }

    public static String parsePath(String url) {
        return url.contains("?") ? url.substring(0, url.indexOf(63)) : url;
    }

    public static String parseQuery(String url) {
        return url.contains("?") ? url.substring(url.indexOf(63) + 1) : null;
    }
}

