/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.selective;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.n2oapp.framework.api.metadata.aware.NamespaceUriAware;
import net.n2oapp.framework.api.metadata.io.IOProcessor;
import net.n2oapp.framework.api.metadata.io.IOProcessorAware;
import net.n2oapp.framework.api.metadata.io.NamespaceIO;
import net.n2oapp.framework.api.metadata.reader.ElementReaderFactory;
import net.n2oapp.framework.api.pack.XmlIOBuilder;
import net.n2oapp.framework.config.io.IOProcessorImpl;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import net.n2oapp.framework.config.selective.SelectiveMetadataLoader;
import net.n2oapp.framework.config.selective.SelectiveUtil;
import net.n2oapp.framework.config.selective.persister.PersisterFactoryByMap;
import net.n2oapp.framework.config.selective.reader.ReaderFactoryByMap;
import net.n2oapp.framework.config.util.XmlUtil;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameQualifier;
import org.custommonkey.xmlunit.ElementQualifier;
import org.custommonkey.xmlunit.XMLUnit;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlIOReader
extends SelectiveMetadataLoader
implements XmlIOBuilder<XmlIOReader> {
    private static final Logger logger;
    private static final BiFunction<String, String, Boolean> CANONICAL_COMPARATOR;
    private static final XMLOutputter XML_OUTPUTTER;
    private PersisterFactoryByMap persisterFactory;
    private IOProcessor persisterProcessor;

    public XmlIOReader() {
        super(new ReaderFactoryByMap());
        ReaderJdomUtil.clearTextProcessing();
        this.persisterFactory = new PersisterFactoryByMap();
        this.persisterProcessor = new IOProcessorImpl(this.persisterFactory);
    }

    public XmlIOReader addIO(NamespaceIO<? extends NamespaceUriAware> io) {
        this.add(io);
        this.persisterFactory.register(io);
        if (io instanceof IOProcessorAware) {
            ((IOProcessorAware)io).setIOProcessor(this.persisterProcessor);
        }
        return this;
    }

    public <T> T read(String source) {
        return (T)SelectiveUtil.read(source, (ElementReaderFactory)this.readerFactory);
    }

    @SafeVarargs
    public final XmlIOReader ios(NamespaceIO<? extends NamespaceUriAware> ... ios) {
        Stream.of(ios).forEach(this::addIO);
        return this;
    }

    public boolean persistAndCompareWithSample(NamespaceUriAware n2o, String sample) {
        return this.compareWithSample(n2o, sample, CANONICAL_COMPARATOR);
    }

    private boolean compareWithSample(NamespaceUriAware n2o, String sample, BiFunction<String, String, Boolean> comparator) {
        return comparator.apply(this.toString(n2o), sample);
    }

    private String toString(NamespaceUriAware n2o) {
        Element element = this.persisterFactory.produce(n2o.getClass(), n2o.getNamespace()).persist((Object)n2o, n2o.getNamespace());
        return XML_OUTPUTTER.outputString(element);
    }

    static {
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        logger = LoggerFactory.getLogger(XmlIOReader.class);
        CANONICAL_COMPARATOR = (s1, s2) -> {
            try {
                Diff diff = XMLUnit.compareXML((String)s1, (String)s2);
                diff.overrideElementQualifier((ElementQualifier)new ElementNameQualifier());
                boolean similar = diff.similar();
                logger.debug("Comparing two xml...\nSource:\n{}\nPersisted:\n{}\nSimilar? {}\nIdentical? {}", new Object[]{s2, s1, similar, diff.identical()});
                logger.debug(diff.toString());
                return similar;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        XML_OUTPUTTER = new XMLOutputter(XmlUtil.N2O_FORMAT);
    }
}

