/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.util;

import java.util.HashMap;
import java.util.Map;

public class StylesResolver {
    private StylesResolver() {
    }

    public static Map<String, String> resolveStyles(String input) {
        String[] lines;
        if (input == null || input.trim().length() == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : lines = input.split(";")) {
            String[] lineArr = line.split(":");
            if (lineArr.length != 2) {
                throw new IllegalArgumentException("Invalid string of styles");
            }
            String key = StylesResolver.kebabToCamelCase(lineArr[0].replaceAll("[\\t ]", ""));
            String value = lineArr[1];
            while (value.startsWith(" ")) {
                value = value.replaceFirst("[\\t ]", "");
            }
            result.put(key, value);
        }
        return result;
    }

    private static String kebabToCamelCase(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '-' && i + 1 < s.length()) {
                builder.append(Character.toUpperCase(s.charAt(++i)));
                continue;
            }
            builder.append(s.charAt(i));
        }
        return builder.toString();
    }
}

