package net.n2oapp.framework.config.reader.widget;

import net.n2oapp.framework.api.metadata.global.view.widget.table.N2oSwitch;
import org.jdom.Element;
import org.jdom.Namespace;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;

import java.util.HashMap;
import java.util.Map;

/**
 * User: iryabov
 * Date: 04.03.14
 * Time: 12:16
 */
public class SwitchReader implements TypedElementReader<N2oSwitch> {
    private String switchValueAttributeName;

    public SwitchReader(String switchValueAttributeName) {
        this.switchValueAttributeName = switchValueAttributeName;
    }

    public SwitchReader() {
    }

    @Override
    public N2oSwitch read(Element element) {
        Element switchEl = element.getChild("switch", element.getNamespace());
        N2oSwitch res = new N2oSwitch();
        if (switchEl != null) {
            Map<String, String> map = new HashMap<>();
            for (Object el : switchEl.getChildren("case", element.getNamespace())) {
                Element e = (Element) el;
                map.put(ReaderJdomUtil.getAttributeString(e, "value"), e.getValue());
            }
            res.setCases(map);
            res.setDefaultCase(ReaderJdomUtil.getElementString(switchEl, "default"));
            res.setValueFieldId(ReaderJdomUtil.getAttributeString(switchEl, "value-field-id"));
        }
        if (switchValueAttributeName != null)
            res.setFieldId(ReaderJdomUtil.getAttributeString(element, switchValueAttributeName));
        return res;
    }

    @Override
    public Class<N2oSwitch> getElementClass() {
        return N2oSwitch.class;
    }

    @Override
    public String getElementName() {
        throw new UnsupportedOperationException("SwitchReader can't be generated by factory");
    }
}
