/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config;

import java.io.File;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.event.N2oEvent;
import net.n2oapp.framework.api.event.N2oEventBus;
import net.n2oapp.framework.api.event.N2oReadyEvent;
import net.n2oapp.framework.api.event.N2oStartedEvent;
import net.n2oapp.framework.api.event.N2oStoppedEvent;
import net.n2oapp.framework.api.metadata.reader.ConfigMetadataLocker;
import net.n2oapp.framework.config.N2oApplicationBuilder;
import net.n2oapp.framework.config.XMLChangeListener;
import net.n2oapp.framework.config.register.storage.PathUtil;
import net.n2oapp.properties.StaticProperties;
import net.n2oapp.watchdir.FileChangeListener;
import net.n2oapp.watchdir.WatchDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStarter {
    private static final Logger logger = LoggerFactory.getLogger(ConfigStarter.class);
    private static volatile boolean wasRunning = false;
    private static final ReadWriteLock startingLock = new ReentrantReadWriteLock();
    private N2oEventBus eventBus;
    private ConfigMetadataLocker locker;
    private WatchDir watchDir;
    private String configPath;
    private N2oApplicationBuilder applicationBuilder;

    public ConfigStarter(N2oApplicationBuilder applicationBuilder, N2oEventBus eventBus, ConfigMetadataLocker locker, WatchDir watchDir, String configPath) {
        this.eventBus = eventBus;
        this.locker = locker;
        this.applicationBuilder = applicationBuilder;
        this.watchDir = watchDir;
        this.configPath = configPath;
    }

    public void restart() {
        if (!startingLock.writeLock().tryLock()) {
            return;
        }
        try {
            this.syncStop();
            this.locker.unlock();
            this.syncStart();
        }
        finally {
            startingLock.writeLock().unlock();
        }
        this.eventBus.publish((N2oEvent)new N2oReadyEvent((Object)this));
    }

    public void start() {
        if (wasRunning) {
            return;
        }
        if (!startingLock.writeLock().tryLock()) {
            return;
        }
        try {
            this.syncStart();
        }
        finally {
            startingLock.writeLock().unlock();
        }
        this.eventBus.publish((N2oEvent)new N2oReadyEvent((Object)this));
    }

    public String getConfigPath() {
        return this.configPath;
    }

    private void syncStart() {
        logger.debug("N2O is starting");
        this.doRegisterInfo();
        this.startMonitoringXml();
        wasRunning = true;
        this.eventBus.publish((N2oEvent)new N2oStartedEvent((Object)this));
        logger.info("N2O was started");
    }

    private void doRegisterInfo() {
        this.applicationBuilder.scan();
    }

    private void startMonitoringXml() {
        boolean watchEnabled = StaticProperties.getBoolean((String)"n2o.config.monitoring.enabled");
        if (!watchEnabled) {
            return;
        }
        String path = this.getConfigPath();
        if (path == null) {
            logger.info("Monitoring did not start: path is null");
            return;
        }
        logger.info("Start monitoring path: " + path);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        MetadataEnvironment environment = this.applicationBuilder.getEnvironment();
        this.watchDir.setListener((FileChangeListener)new XMLChangeListener(path, environment.getMetadataRegister(), environment.getSourceTypeRegister(), this.eventBus));
        this.watchDir.addPath(path);
        StaticProperties.getList((String)"n2o.config.ignores").forEach(skip -> this.watchDir.skipOn(PathUtil.concatAbsoluteAndLocalPath(path, skip)));
        this.watchDir.start();
    }

    private void stopMonitoringXml() {
        this.watchDir.stop();
    }

    public void stop() {
        if (!wasRunning) {
            return;
        }
        if (!startingLock.writeLock().tryLock()) {
            return;
        }
        try {
            this.syncStop();
        }
        finally {
            startingLock.writeLock().unlock();
        }
    }

    private void syncStop() {
        logger.debug("N2O is stopping");
        wasRunning = false;
        this.stopMonitoringXml();
        this.eventBus.publish((N2oEvent)new N2oStoppedEvent((Object)this));
        logger.info("N2O was stopped");
    }

    public static void waitUntilStarted() {
        startingLock.readLock().lock();
        startingLock.readLock().unlock();
    }
}

