/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.n2oapp.criteria.dataset.DataSet;
import net.n2oapp.framework.api.MetadataEnvironment;
import net.n2oapp.framework.api.PlaceHoldersResolver;
import net.n2oapp.framework.api.StringUtils;
import net.n2oapp.framework.api.metadata.Compiled;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.SourceMetadata;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.BindProcessor;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.ExtensionAttributeMapperFactory;
import net.n2oapp.framework.api.metadata.meta.BindLink;
import net.n2oapp.framework.api.metadata.meta.ModelLink;
import net.n2oapp.framework.api.metadata.meta.control.DefaultValues;
import net.n2oapp.framework.api.metadata.pipeline.BindTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.CompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadCompileTerminalPipeline;
import net.n2oapp.framework.api.metadata.pipeline.ReadTerminalPipeline;
import net.n2oapp.framework.api.metadata.validate.ValidateProcessor;
import net.n2oapp.framework.api.metadata.validation.exception.N2oMetadataValidationException;
import net.n2oapp.framework.api.script.ScriptProcessor;
import net.n2oapp.framework.config.compile.pipeline.N2oPipelineSupport;
import net.n2oapp.framework.config.metadata.compile.DataModel;
import net.n2oapp.framework.config.register.route.RouteUtil;

public class N2oCompileProcessor
implements CompileProcessor,
BindProcessor,
ValidateProcessor {
    private static final PlaceHoldersResolver LINK_RESOLVER = new PlaceHoldersResolver("{", "}", new String[0]);
    private static final PlaceHoldersResolver URL_RESOLVER = new PlaceHoldersResolver(":", "", new String[0]);
    private MetadataEnvironment env;
    private Map<Class<?>, Object> scope = Collections.emptyMap();
    private CompileContext<?, ?> context;
    private DataSet params;
    private DataModel model;
    private BindTerminalPipeline bindPipeline;
    private CompileTerminalPipeline<?> compilePipeline;
    private ReadCompileTerminalPipeline<?> readCompilePipeline;
    private ReadTerminalPipeline<?> readPipeline;

    public N2oCompileProcessor(MetadataEnvironment env) {
        this.env = env;
        N2oPipelineSupport pipelineSupport = new N2oPipelineSupport(env);
        this.bindPipeline = (BindTerminalPipeline)env.getBindPipelineFunction().apply((Object)pipelineSupport);
        this.readPipeline = (ReadTerminalPipeline)env.getReadPipelineFunction().apply((Object)pipelineSupport);
        this.readCompilePipeline = (ReadCompileTerminalPipeline)env.getReadCompilePipelineFunction().apply((Object)pipelineSupport);
        this.compilePipeline = (CompileTerminalPipeline)env.getCompilePipelineFunction().apply((Object)pipelineSupport);
    }

    public N2oCompileProcessor(MetadataEnvironment env, CompileContext<?, ?> context, DataSet params) {
        this(env);
        this.context = context;
        this.params = params;
        this.model = new DataModel();
        this.model.addAll(context.getQueryRouteMapping(), params);
        this.model.addAll(context.getPathRouteMapping(), params);
    }

    private N2oCompileProcessor(N2oCompileProcessor parent, Object ... scope) {
        this.env = parent.env;
        this.scope = new HashMap(parent.scope);
        Stream.of(Optional.ofNullable(scope).orElse(new Compiled[0])).filter(Objects::nonNull).forEach(s -> this.scope.put(s.getClass(), s));
        this.readPipeline = parent.readPipeline;
        this.readCompilePipeline = parent.readCompilePipeline;
        this.compilePipeline = parent.compilePipeline;
        this.params = parent.params;
        this.context = parent.context;
    }

    public <D extends Compiled, S> D compile(S source, CompileContext<?, ?> context, Object ... scope) {
        return (D)this.compilePipeline.get(source, context, (CompileProcessor)new N2oCompileProcessor(this, scope));
    }

    public <D extends Compiled> void bind(D compiled) {
        this.bindPipeline.get(compiled, this.context, this.params);
    }

    public Map<String, Object> mapAttributes(ExtensionAttributesAware source) {
        if (source.getExtAttributes() == null) {
            return null;
        }
        ExtensionAttributeMapperFactory extensionAttributeMapperFactory = this.env.getExtensionAttributeMapperFactory();
        HashMap<String, Object> extAttributes = new HashMap<String, Object>();
        source.getExtAttributes().forEach((k, v) -> {
            Map res = extensionAttributeMapperFactory.mapAttributes(v, k.getUri());
            if (res != null) {
                extAttributes.putAll(res);
            }
        });
        return extAttributes;
    }

    public <D extends Compiled> D getCompiled(CompileContext<D, ?> context) {
        return (D)this.readCompilePipeline.get(context);
    }

    public <D> D getScope(Class<D> scopeClass) {
        return (D)this.scope.get(scopeClass);
    }

    public <S extends SourceMetadata> S getSource(String id, Class<S> sourceClass) {
        return (S)this.readPipeline.get(id, sourceClass);
    }

    public <D extends Compiled> void addRoute(CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(context.getRoute((BindProcessor)this), context);
    }

    public <D extends Compiled> void addRoute(String route, CompileContext<D, ?> context) {
        this.env.getRouteRegister().addRoute(route, context);
    }

    public <T> T resolve(String placeholder, Class<T> clazz) {
        Object value = this.resolvePlaceholder(placeholder);
        return (T)this.env.getDomainProcessor().deserialize(value, clazz);
    }

    public Object resolve(String placeholder, String domain) {
        Object value = this.resolvePlaceholder(placeholder);
        return this.env.getDomainProcessor().deserialize(value, domain);
    }

    public Object resolve(String placeholder) {
        Object value = this.resolvePlaceholder(placeholder);
        return this.env.getDomainProcessor().deserialize(value);
    }

    public String resolveText(String text) {
        if (StringUtils.hasProperty((String)text)) {
            return this.env.getSystemProperties().resolvePlaceholders(text);
        }
        if (StringUtils.hasContext((String)text)) {
            return this.env.getContextProcessor().resolveText(text);
        }
        return text;
    }

    public String getMessage(String messageCode, Object ... arguments) {
        String defaultMessage = messageCode.contains("{0}") ? MessageFormat.format(messageCode, arguments) : messageCode;
        return this.env.getMessageSource().getMessage(messageCode, arguments, defaultMessage);
    }

    public Object resolveJS(String text, Class<?> clazz) {
        String value = ScriptProcessor.resolveLinks((String)text);
        return this.env.getDomainProcessor().deserialize((Object)value, clazz);
    }

    public String resolveUrl(String url) {
        return URL_RESOLVER.resolve(url, (Object)this.params);
    }

    public String resolveUrl(String url, Map<String, ? extends BindLink> pathMappings, Map<String, ? extends BindLink> queryMappings) {
        String resultUrl = url;
        if (pathMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(pathMappings, (String)k));
        }
        if (queryMappings != null) {
            resultUrl = URL_RESOLVER.resolve(resultUrl, k -> this.getValue(queryMappings, (String)k));
        }
        resultUrl = URL_RESOLVER.resolve(resultUrl, (Object)this.params);
        return resultUrl;
    }

    public String resolveUrl(String url, ModelLink link) {
        List<String> paramNames = RouteUtil.getParams(url);
        if (paramNames == null || paramNames.isEmpty() || this.params == null) {
            return url;
        }
        HashMap<String, String> valueParamMap = new HashMap<String, String>();
        this.collectModelLinks(this.context.getPathRouteMapping(), link.getWidgetLink(), valueParamMap);
        this.collectModelLinks(this.context.getQueryRouteMapping(), link.getWidgetLink(), valueParamMap);
        for (String param : paramNames) {
            if (!valueParamMap.containsKey(param) || !this.params.containsKey(valueParamMap.get(param))) continue;
            url = url.replace(":" + param, this.params.get(valueParamMap.get(param)).toString());
        }
        return url;
    }

    public <L extends BindLink> void resolveLink(L link) {
        if (link == null || link.getBindLink() == null || this.context == null || this.context.getQueryRouteMapping() == null) {
            return;
        }
        Optional<Object> res = Optional.empty();
        if (this.context.getQueryRouteMapping() != null) {
            res = this.context.getQueryRouteMapping().keySet().stream().filter(ri -> ((ModelLink)this.context.getQueryRouteMapping().get(ri)).equals((Object)link)).findAny();
        }
        if (!res.isPresent() && this.context.getPathRouteMapping() != null) {
            res = this.context.getPathRouteMapping().keySet().stream().filter(ri -> ((ModelLink)this.context.getPathRouteMapping().get(ri)).equals((Object)link)).findAny();
        }
        if (res.isPresent()) {
            Object value = this.params.get(res.get());
            if (value instanceof String) {
                value = this.resolveText((String)value);
            }
            if (value != null) {
                link.setValue(value);
            }
        }
    }

    public void resolveSubModels(ModelLink link, List<ModelLink> linkList) {
        if (link.getSubModelQuery() == null) {
            return;
        }
        for (ModelLink modelLink : linkList) {
            if (!link.equalsLink((Object)modelLink)) continue;
            this.resolveDefaultValues(modelLink, link);
        }
        this.executeSubModels(link);
    }

    public String resolveText(String text, ModelLink link) {
        String resolved = this.resolveText(text);
        if (link != null) {
            return LINK_RESOLVER.resolve(resolved, this.model.getDataIfAbsent(link, this.env.getSubModelsProcessor()));
        }
        return resolved;
    }

    public <T extends Source> void validate(T metadata) {
        if (metadata == null) {
            return;
        }
        this.env.getSourceValidatorFactory().validate(metadata, (ValidateProcessor)this);
    }

    public <T extends SourceMetadata> T getOrNull(String id, Class<T> metadataClass) {
        if (id == null) {
            return null;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            return null;
        }
        try {
            return this.getSource(id, metadataClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T extends SourceMetadata> T getOrThrow(String id, Class<T> metadataClass) {
        if (id == null) {
            return null;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            return null;
        }
        return this.getSource(id, metadataClass);
    }

    public <T extends SourceMetadata> void checkForExists(String id, Class<T> metadataClass, String errorMessage) {
        if (id == null) {
            return;
        }
        if (!this.env.getMetadataRegister().contains(id, metadataClass)) {
            throw new N2oMetadataValidationException(this.getMessage(errorMessage, id));
        }
    }

    private Object resolvePlaceholder(String placeholder) {
        String value = placeholder;
        if (StringUtils.isProperty((String)placeholder)) {
            value = this.env.getSystemProperties().resolvePlaceholders(placeholder);
        }
        return value;
    }

    private void collectModelLinks(Map<String, ModelLink> linkMap, ModelLink link, Map<String, String> resultMap) {
        if (linkMap != null) {
            linkMap.forEach((k, v) -> {
                if (v.equalsLink((Object)link)) {
                    resultMap.put((String)k, (String)k);
                    resultMap.put(v.getFieldId(), (String)k);
                }
            });
        }
    }

    private void executeSubModels(ModelLink link) {
        if (link.getValue() == null) {
            return;
        }
        if (link.getValue() instanceof List) {
            for (DefaultValues defaultValues : (List)link.getValue()) {
                DataSet dataSet = new DataSet();
                dataSet.put(link.getFieldId(), (Object)defaultValues.getValues());
                this.env.getSubModelsProcessor().executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
                defaultValues.setValues((Map)dataSet.get((Object)link.getFieldId()));
            }
        } else if (link.getValue() instanceof DefaultValues) {
            DataSet dataSet = new DataSet();
            dataSet.put(link.getFieldId(), (Object)((DefaultValues)link.getValue()).getValues());
            this.env.getSubModelsProcessor().executeSubModels(Collections.singletonList(link.getSubModelQuery()), dataSet);
            ((DefaultValues)link.getValue()).setValues((Map)dataSet.get((Object)link.getFieldId()));
        }
    }

    private void resolveDefaultValues(ModelLink src, ModelLink dst) {
        if (src.getParam() != null && this.params.containsKey((Object)src.getParam())) {
            if (this.params.get((Object)src.getParam()) instanceof List) {
                ArrayList<DefaultValues> values = new ArrayList<DefaultValues>();
                for (Object value : (List)this.params.get((Object)src.getParam())) {
                    DefaultValues defaultValues = new DefaultValues();
                    defaultValues.setValues(new HashMap());
                    defaultValues.getValues().put(src.getSubModelQuery().getValueFieldId(), value);
                    values.add(defaultValues);
                }
                if (!values.isEmpty()) {
                    dst.setValue(values);
                }
            } else {
                DefaultValues defaultValues = new DefaultValues();
                defaultValues.setValues(new HashMap());
                defaultValues.getValues().put(src.getSubModelQuery().getValueFieldId(), this.params.get((Object)src.getParam()));
                dst.setValue((Object)(src.getSubModelQuery().getMulti() != null && src.getSubModelQuery().getMulti() != false ? Collections.singletonList(defaultValues) : defaultValues));
            }
        }
    }

    private Object getValue(Map<String, ? extends BindLink> mapping, String key) {
        if (!mapping.containsKey(key)) {
            return null;
        }
        BindLink bindLink = mapping.get(key);
        if (bindLink instanceof ModelLink) {
            Object value = this.model.getValue((ModelLink)bindLink);
            if (value != null) {
                mapping.remove(key);
            }
            return value;
        }
        return null;
    }
}

