/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.header;

import net.n2oapp.framework.api.metadata.header.N2oSimpleHeader;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.config.metadata.compile.menu.SimpleMenuReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.stereotype.Component;

@Component
public class SimpleHeaderReader
extends AbstractFactoredReader<N2oSimpleHeader> {
    private SimpleMenuReader menuReader = new SimpleMenuReader();

    public String getNamespaceUri() {
        return "http://n2oapp.net/framework/config/schema/simple-header-1.0";
    }

    public N2oSimpleHeader read(Element element, Namespace namespace) {
        Element userMenu;
        N2oSimpleHeader header = new N2oSimpleHeader();
        header.setName(ReaderJdomUtil.getElementString(element, "project-name"));
        header.setSrc(ReaderJdomUtil.getAttributeString(element, "src"));
        header.setCssClass(ReaderJdomUtil.getAttributeString(element, "css-class"));
        header.setProjectName(ReaderJdomUtil.getElementString(element, "project-name"));
        header.setProjectImageSrc(ReaderJdomUtil.getElementString(element, "project-image-src"));
        header.setNamespaceUri(this.getNamespaceUri());
        Element menu = element.getChild("menu", namespace);
        if (menu != null) {
            this.readMenu(menu, namespace, header);
        }
        if ((userMenu = element.getChild("user-menu", namespace)) != null) {
            header.setUserMenuSrc(ReaderJdomUtil.getAttributeString(userMenu, "src"));
            header.setUserContext(ReaderJdomUtil.getAttributeString(userMenu, "username-context"));
            header.setProfilePageId(ReaderJdomUtil.getAttributeString(userMenu, "profile-page-id"));
            header.setLoginUrl(ReaderJdomUtil.getAttributeString(userMenu, "login-url"));
            header.setLogoutUrl(ReaderJdomUtil.getAttributeString(userMenu, "logout-url"));
            header.setRegistrationUrl(ReaderJdomUtil.getAttributeString(userMenu, "registration-url"));
        }
        return header;
    }

    private void readMenu(Element element, Namespace namespace, N2oSimpleHeader header) {
        N2oSimpleMenu menu = this.menuReader.read(element, namespace);
        header.setMenu(menu);
    }

    public Class<N2oSimpleHeader> getElementClass() {
        return N2oSimpleHeader.class;
    }

    public String getElementName() {
        return "header";
    }
}

