/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.menu;

import java.util.ArrayList;
import net.n2oapp.framework.api.metadata.global.view.action.control.Target;
import net.n2oapp.framework.api.metadata.menu.N2oSimpleMenu;
import net.n2oapp.framework.api.metadata.reader.AbstractFactoredReader;
import net.n2oapp.framework.api.metadata.reader.TypedElementReader;
import net.n2oapp.framework.config.reader.util.ReaderJdomUtil;
import org.jdom.Element;
import org.jdom.Namespace;

public class SimpleMenuReader
extends AbstractFactoredReader<N2oSimpleMenu> {
    public String getNamespaceUri() {
        return "http://n2oapp.net/framework/config/schema/simple-menu-1.0";
    }

    public N2oSimpleMenu read(Element element, Namespace namespace) {
        N2oSimpleMenu menu = new N2oSimpleMenu();
        String refId = ReaderJdomUtil.getAttributeString(element, "ref-id");
        if (refId != null) {
            menu.setRefId(refId);
        }
        menu.setSrc(ReaderJdomUtil.getAttributeString(element, "src"));
        menu.setNamespaceUri(this.getNamespaceUri());
        ArrayList<N2oSimpleMenu.MenuItem> menuItems = new ArrayList<N2oSimpleMenu.MenuItem>();
        for (Element child : element.getChildren()) {
            N2oSimpleMenu.MenuItem item = new SimpleMenuItemReader().read(child);
            menuItems.add(item);
        }
        menu.setMenuItems(menuItems.toArray(new N2oSimpleMenu.MenuItem[menuItems.size()]));
        return menu;
    }

    public Class<N2oSimpleMenu> getElementClass() {
        return N2oSimpleMenu.class;
    }

    public String getElementName() {
        return "menu";
    }

    private static class SimpleMenuItemReader
    implements TypedElementReader<N2oSimpleMenu.MenuItem> {
        private SimpleMenuItemReader() {
        }

        public N2oSimpleMenu.MenuItem read(Element element) {
            N2oSimpleMenu.PageItem item = null;
            if (element.getName().equals("page")) {
                item = new N2oSimpleMenu.PageItem();
                item.setPageId(ReaderJdomUtil.getAttributeString(element, "page-id"));
                item.setRoute(ReaderJdomUtil.getAttributeString(element, "route"));
            }
            if (element.getName().equals("a")) {
                item = new N2oSimpleMenu.AnchorItem();
                item.setHref(ReaderJdomUtil.getAttributeString(element, "href"));
            }
            if (item == null) {
                item = new N2oSimpleMenu.MenuItem();
            }
            if (element.getName().equals("sub-menu")) {
                item.setSubMenu(ReaderJdomUtil.getChildren(element, null, null, new SimpleMenuItemReader()));
            }
            item.setTarget(ReaderJdomUtil.getAttributeEnum(element, "target", Target.class));
            item.setLabel(ReaderJdomUtil.getAttributeString(element, "label"));
            item.setIcon(ReaderJdomUtil.getAttributeString(element, "icon"));
            return item;
        }

        public Class<N2oSimpleMenu.MenuItem> getElementClass() {
            return N2oSimpleMenu.MenuItem.class;
        }

        public String getElementName() {
            return "temp";
        }
    }
}

