/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.page;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.n2oapp.framework.api.data.validation.Validation;
import net.n2oapp.framework.api.exception.N2oException;
import net.n2oapp.framework.api.metadata.ReduxModel;
import net.n2oapp.framework.api.metadata.aware.ExtensionAttributesAware;
import net.n2oapp.framework.api.metadata.compile.CompileContext;
import net.n2oapp.framework.api.metadata.compile.CompileProcessor;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.global.view.ActionsBar;
import net.n2oapp.framework.api.metadata.global.view.page.GenerateType;
import net.n2oapp.framework.api.metadata.global.view.page.N2oPage;
import net.n2oapp.framework.api.metadata.global.view.page.N2oStandardPage;
import net.n2oapp.framework.api.metadata.global.view.region.N2oRegion;
import net.n2oapp.framework.api.metadata.global.view.widget.N2oWidget;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.AbstractMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oButton;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oGroup;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oMenuItem;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oSubmenu;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.N2oToolbar;
import net.n2oapp.framework.api.metadata.global.view.widget.toolbar.ToolbarItem;
import net.n2oapp.framework.api.metadata.local.CompiledObject;
import net.n2oapp.framework.api.metadata.local.util.StrictMap;
import net.n2oapp.framework.api.metadata.meta.BreadcrumbList;
import net.n2oapp.framework.api.metadata.meta.Layout;
import net.n2oapp.framework.api.metadata.meta.Models;
import net.n2oapp.framework.api.metadata.meta.Page;
import net.n2oapp.framework.api.metadata.meta.PageRoutes;
import net.n2oapp.framework.api.metadata.meta.action.Action;
import net.n2oapp.framework.api.metadata.meta.region.Region;
import net.n2oapp.framework.api.metadata.meta.toolbar.Toolbar;
import net.n2oapp.framework.api.metadata.meta.widget.Widget;
import net.n2oapp.framework.config.metadata.compile.ComponentScope;
import net.n2oapp.framework.config.metadata.compile.IndexScope;
import net.n2oapp.framework.config.metadata.compile.PageRoutesScope;
import net.n2oapp.framework.config.metadata.compile.ParentRouteScope;
import net.n2oapp.framework.config.metadata.compile.ValidationList;
import net.n2oapp.framework.config.metadata.compile.context.ModalPageContext;
import net.n2oapp.framework.config.metadata.compile.context.ObjectContext;
import net.n2oapp.framework.config.metadata.compile.context.PageContext;
import net.n2oapp.framework.config.metadata.compile.page.BasePageCompiler;
import net.n2oapp.framework.config.metadata.compile.page.PageScope;
import net.n2oapp.framework.config.metadata.compile.widget.MetaActions;
import net.n2oapp.framework.config.metadata.compile.widget.WidgetScope;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class StandardPageCompiler
extends BasePageCompiler<N2oStandardPage> {
    public Page compile(N2oStandardPage source, PageContext context, CompileProcessor p) {
        Page page = new Page();
        String pageRoute = this.initPageRoute((N2oPage)source, context, p);
        page.setId((String)p.cast((Object)context.getClientPageId(), (Object)RouteUtil.convertPathToId(pageRoute), new Object[0]));
        PageScope pageScope = new PageScope();
        pageScope.setPageId(page.getId());
        String pageName = (String)p.cast((Object)context.getPageName(), (Object)source.getName(), new Object[0]);
        page.setPageProperty(this.initPageName(pageName, context, p));
        page.setProperties(p.mapAttributes((ExtensionAttributesAware)source));
        BreadcrumbList breadcrumb = this.initBreadcrumb(pageName, context, p);
        page.setBreadcrumb((List)breadcrumb);
        page.setWidgets((Map)new StrictMap());
        Models models = new Models();
        page.setModels(models);
        PageRoutes pageRoutes = new PageRoutes();
        pageRoutes.addRoute(new PageRoutes.Route(pageRoute));
        List<N2oWidget> sourceWidgets = this.collectWidgets(source);
        this.initDefaults(context, sourceWidgets);
        ParentRouteScope routeScope = new ParentRouteScope(pageRoute, context.getPathRouteMapping(), context.getQueryRouteMapping());
        ValidationList validationList = new ValidationList(new HashMap<ReduxModel, Map<String, List<Validation>>>());
        PageRoutesScope pageRoutesScope = new PageRoutesScope();
        page.setWidgets(this.initWidgets(routeScope, pageRoutes, sourceWidgets, context, p, pageScope, breadcrumb, validationList, models, pageRoutesScope));
        this.registerRoutes(pageRoutes, context, p);
        if (!(context instanceof ModalPageContext)) {
            page.setRoutes(pageRoutes);
        }
        page.setLayout(this.createLayout(source, p, context, pageScope));
        CompiledObject object = source.getObjectId() != null ? (CompiledObject)p.getCompiled((CompileContext)new ObjectContext(source.getObjectId())) : null;
        page.setObject(object);
        if (context.getSubmitOperationId() != null) {
            this.initToolbarGenerate(source, context, p, sourceWidgets);
        }
        MetaActions metaActions = new MetaActions();
        this.compileToolbarAndAction(page, source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumb, validationList);
        page.setActions((Map)((Object)metaActions));
        return page;
    }

    private void initDefaults(PageContext context, List<N2oWidget> sourceWidgets) {
        if (context.getPreFilters() != null && !context.getPreFilters().isEmpty() || context.getUpload() != null) {
            N2oWidget widget = this.initResultWidget(context, sourceWidgets);
            widget.addPreFilters(context.getPreFilters());
            widget.setUpload(context.getUpload());
        }
    }

    private String initResultWidgetId(PageContext context, List<N2oWidget> sourceWidgets) {
        String resultWidgetId = context.getResultWidgetId();
        if (resultWidgetId == null) {
            List<N2oWidget> sourceIndependents = this.getSourceIndependents(sourceWidgets);
            if (sourceIndependents.size() == 1) {
                resultWidgetId = sourceIndependents.get(0).getId();
            } else {
                throw new N2oException("Can't get result widget id. There were two independent's widgets");
            }
        }
        return resultWidgetId;
    }

    private N2oWidget initResultWidget(PageContext context, List<N2oWidget> sourceWidgets) {
        String resultWidgetId = context.getResultWidgetId();
        if (resultWidgetId != null) {
            for (N2oWidget sourceWidget : sourceWidgets) {
                if (sourceWidget.getId() == null || !sourceWidget.getId().equals(resultWidgetId)) continue;
                return sourceWidget;
            }
            throw new N2oException("Widget " + resultWidgetId + " not found!");
        }
        List<N2oWidget> sourceIndependents = this.getSourceIndependents(sourceWidgets);
        if (sourceIndependents.size() == 1) {
            return sourceIndependents.get(0);
        }
        throw new N2oException("Can't get result widget id. There were two independent's widgets");
    }

    private void compileToolbarAndAction(Page compiled, N2oStandardPage source, PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList) {
        this.actionsToToolbar(source);
        compiled.setToolbar(this.compileToolbar(source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList));
        this.compileActions(source, context, p, metaActions, pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList);
    }

    private void actionsToToolbar(N2oStandardPage source) {
        if (source.getActions() == null || source.getToolbars() == null) {
            return;
        }
        HashMap<String, ActionsBar> actionMap = new HashMap<String, ActionsBar>();
        Stream.of(source.getActions()).forEach(a -> actionMap.put(a.getId(), (ActionsBar)a));
        for (N2oToolbar toolbar : source.getToolbars()) {
            if (toolbar.getItems() == null) continue;
            ToolbarItem[] toolbarItems = toolbar.getItems();
            this.copyActionForToolbarItem(actionMap, toolbarItems);
        }
    }

    private void copyActionForToolbarItem(Map<String, ActionsBar> actionMap, ToolbarItem[] toolbarItems) {
        for (ToolbarItem item : toolbarItems) {
            if (item instanceof N2oButton || item instanceof N2oMenuItem) {
                this.copyAction((AbstractMenuItem)item, actionMap);
                continue;
            }
            if (item instanceof N2oSubmenu) {
                for (N2oMenuItem subItem : ((N2oSubmenu)item).getMenuItems()) {
                    this.copyAction((AbstractMenuItem)subItem, actionMap);
                }
                continue;
            }
            if (!(item instanceof N2oGroup)) continue;
            this.copyActionForToolbarItem(actionMap, (ToolbarItem[])((N2oGroup)item).getItems());
        }
    }

    private void copyAction(AbstractMenuItem item, Map<String, ActionsBar> actionMap) {
        AbstractMenuItem mi = item;
        if (mi.getAction() == null && mi.getActionId() != null) {
            ActionsBar action = actionMap.get(mi.getActionId());
            if (action == null) {
                throw new N2oException("Toolbar has reference to nonexistent action by actionId {0}!").addData(new Object[]{mi.getActionId()});
            }
            mi.setAction(action.getAction());
            if (mi.getModel() == null) {
                mi.setModel(action.getModel());
            }
            if (mi.getWidgetId() == null) {
                mi.setWidgetId(action.getWidgetId());
            }
            if (mi.getLabel() == null) {
                mi.setLabel(action.getLabel());
            }
            if (mi.getIcon() == null) {
                mi.setIcon(action.getIcon());
            }
        }
    }

    private Toolbar compileToolbar(N2oStandardPage source, PageContext context, CompileProcessor p, MetaActions metaActions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList) {
        if (source.getToolbars() == null) {
            return null;
        }
        Toolbar toolbar = new Toolbar();
        for (N2oToolbar n2oToolbar : source.getToolbars()) {
            toolbar.putAll((Map)p.compile((Object)n2oToolbar, (CompileContext)context, new Object[]{metaActions, pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList, new IndexScope()}));
        }
        return toolbar;
    }

    private Map<String, Widget> initWidgets(ParentRouteScope routeScope, PageRoutes pageRoutes, List<N2oWidget> sourceWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, PageRoutesScope pageRoutesScope) {
        StrictMap compiledWidgets = new StrictMap();
        IndexScope indexScope = new IndexScope();
        List<N2oWidget> independents = this.getSourceIndependents(sourceWidgets);
        independents.forEach(arg_0 -> this.lambda$initWidgets$1(pageRoutes, routeScope, sourceWidgets, (Map)compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope, arg_0));
        return compiledWidgets;
    }

    private void compileWidget(N2oWidget w, PageRoutes routes, ParentRouteScope parentRoute, String parentWidgetId, String parentQueryId, List<N2oWidget> sourceWidgets, Map<String, Widget> compiledWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, PageRoutesScope pageRoutesScope) {
        WidgetScope widgetScope = new WidgetScope();
        widgetScope.setDependsOnWidgetId(parentWidgetId);
        widgetScope.setDependsOnQueryId(parentQueryId);
        Widget compiledWidget = (Widget)p.compile((Object)w, (CompileContext)context, new Object[]{indexScope, routes, pageScope, widgetScope, parentRoute, breadcrumbs, validationList, models, pageRoutesScope});
        compiledWidgets.put(compiledWidget.getId(), compiledWidget);
        ParentRouteScope parentRouteScope = new ParentRouteScope(compiledWidget.getRoute(), parentRoute);
        this.getDetails(w.getId(), sourceWidgets).forEach(detWgt -> this.compileWidget((N2oWidget)detWgt, routes, parentRouteScope, compiledWidget.getId(), compiledWidget.getQueryId(), sourceWidgets, compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope));
    }

    private Layout createLayout(N2oStandardPage source, CompileProcessor p, PageContext context, PageScope pageScope) {
        Layout layout = new Layout();
        layout.setSrc((String)p.cast((Object)source.getLayout(), (Object)((String)p.resolve(Placeholders.property((String)"n2o.api.page.layout.src"), String.class)), new Object[0]));
        HashMap regionMap = new HashMap();
        if (source.getRegions() != null) {
            IndexScope index = new IndexScope();
            for (N2oRegion n2oRegion : source.getRegions().getRegions()) {
                Region region = (Region)p.compile((Object)n2oRegion, (CompileContext)context, new Object[]{index, pageScope});
                String place = (String)p.cast((Object)n2oRegion.getPlace(), (Object)"single", new Object[0]);
                if (regionMap.get(place) != null) {
                    ((List)regionMap.get(place)).add(region);
                    continue;
                }
                ArrayList<Region> regionList = new ArrayList<Region>();
                regionList.add(region);
                regionMap.put(place, regionList);
            }
            layout.setRegions(regionMap);
            layout.setProperties(p.mapAttributes((ExtensionAttributesAware)source.getRegions()));
        }
        return layout;
    }

    public Class<N2oStandardPage> getSourceClass() {
        return N2oStandardPage.class;
    }

    private List<N2oWidget> collectWidgets(N2oStandardPage page) {
        ArrayList<N2oWidget> result = new ArrayList<N2oWidget>();
        if (page.getN2oRegions() != null) {
            for (N2oRegion region : page.getN2oRegions()) {
                if (region.getWidgets() == null) continue;
                result.addAll(Arrays.asList(region.getWidgets()));
            }
        }
        return result;
    }

    private void initToolbarGenerate(N2oStandardPage source, PageContext context, CompileProcessor p, List<N2oWidget> sourceWidgets) {
        N2oToolbar n2oToolbar = new N2oToolbar();
        String[] generate = new String[]{GenerateType.submit.name(), GenerateType.close.name()};
        n2oToolbar.setGenerate(generate);
        String resultWidgetId = this.initResultWidgetId(context, sourceWidgets);
        n2oToolbar.setTargetWidgetId(resultWidgetId);
        if (source.getToolbars() == null) {
            source.setToolbars(new N2oToolbar[0]);
        }
        int length = source.getToolbars().length;
        N2oToolbar[] n2oToolbars = new N2oToolbar[length + 1];
        System.arraycopy(source.getToolbars(), 0, n2oToolbars, 0, length);
        n2oToolbars[length] = n2oToolbar;
        source.setToolbars(n2oToolbars);
    }

    private List<N2oWidget> getSourceIndependents(List<N2oWidget> sourceWidgets) {
        ArrayList<N2oWidget> independents = new ArrayList<N2oWidget>();
        for (N2oWidget widget : sourceWidgets) {
            if (widget.getDependsOn() != null) continue;
            independents.add(widget);
        }
        return independents;
    }

    private List<N2oWidget> getDetails(String widgetId, List<N2oWidget> widgets) {
        ArrayList<N2oWidget> details = new ArrayList<N2oWidget>();
        for (N2oWidget widget : widgets) {
            if (widget.getDependsOn() == null || !widget.getDependsOn().equals(widgetId)) continue;
            details.add(widget);
        }
        return details;
    }

    private void compileActions(N2oStandardPage source, PageContext context, CompileProcessor p, MetaActions actions, PageScope pageScope, ParentRouteScope routeScope, PageRoutes pageRoutes, CompiledObject object, BreadcrumbList breadcrumbs, ValidationList validationList) {
        if (source.getActions() != null) {
            Stream.of(source.getActions()).forEach(a -> {
                a.getAction().setId(a.getId());
                Action action = (Action)p.compile((Object)a.getAction(), (CompileContext)context, new Object[]{pageScope, routeScope, pageRoutes, object, breadcrumbs, validationList, new ComponentScope(a)});
                actions.addAction(action);
            });
        }
    }

    private /* synthetic */ void lambda$initWidgets$1(PageRoutes pageRoutes, ParentRouteScope routeScope, List sourceWidgets, Map compiledWidgets, PageContext context, CompileProcessor p, PageScope pageScope, BreadcrumbList breadcrumbs, ValidationList validationList, Models models, IndexScope indexScope, PageRoutesScope pageRoutesScope, N2oWidget w) {
        this.compileWidget(w, pageRoutes, routeScope, null, null, sourceWidgets, compiledWidgets, context, p, pageScope, breadcrumbs, validationList, models, indexScope, pageRoutesScope);
    }
}

