/*
 * Decompiled with CFR 0.152.
 */
package net.n2oapp.framework.config.metadata.compile.query;

import java.util.Arrays;
import net.n2oapp.framework.api.metadata.Source;
import net.n2oapp.framework.api.metadata.aware.SourceClassAware;
import net.n2oapp.framework.api.metadata.compile.SourceTransformer;
import net.n2oapp.framework.api.metadata.compile.building.Placeholders;
import net.n2oapp.framework.api.metadata.dataprovider.N2oTestDataProvider;
import net.n2oapp.framework.api.metadata.global.dao.N2oQuery;
import net.n2oapp.framework.config.register.route.RouteUtil;
import org.springframework.stereotype.Component;

@Component
public class TestEngineQueryTransformer
implements SourceTransformer<N2oQuery>,
SourceClassAware {
    public N2oQuery transform(N2oQuery source) {
        if (!this.isTest(source)) {
            return source;
        }
        if (source.getFields() != null) {
            for (N2oQuery.Field field : source.getFields()) {
                if (!field.getNoDisplay().booleanValue() && field.getSelectBody() == null) {
                    field.setSelectBody(Placeholders.colon((String)"expression"));
                }
                if (!field.getNoSorting().booleanValue() && field.getSortingBody() == null) {
                    field.setSortingBody(Placeholders.colon((String)"expression") + " " + Placeholders.colon((String)(field.getId() + "Direction")));
                }
                if (field.getFilterList() == null) continue;
                for (N2oQuery.Filter filter : field.getFilterList()) {
                    if (filter.getFilterField() == null) {
                        filter.setFilterField(RouteUtil.normalizeParam(field.getId()) + "_" + filter.getType());
                    }
                    if (filter.getText() != null) continue;
                    filter.setText(Placeholders.colon((String)"expression") + " " + Placeholders.colon((String)filter.getType().name()) + " " + Placeholders.colon((String)filter.getFilterField()));
                }
            }
        }
        return source;
    }

    public Class<? extends Source> getSourceClass() {
        return N2oQuery.class;
    }

    private boolean isTest(N2oQuery source) {
        return this.checkTest(source.getLists()) && this.checkTest(source.getUniques()) && this.checkTest(source.getCounts());
    }

    private boolean checkTest(N2oQuery.Selection[] selection) {
        if (selection == null) {
            return true;
        }
        return Arrays.stream(selection).noneMatch(elem -> !(elem.getInvocation() instanceof N2oTestDataProvider));
    }
}

